/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;

public class EventCallback
implements Serializable {
    public static final int DEFAULT_TIMEOUT = 30000;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(EventCallback.class);
    private static Map<String, Semaphore> eventSemaphores = new HashMap<String, Semaphore>();

    public void processStart() {
        EventCallback.registerNotification("process-start");
    }

    public void processEnd() {
        EventCallback.registerNotification("process-end");
    }

    public void nodeEnter() {
        EventCallback.registerNotification("node-enter");
    }

    public void nodeLeave() {
        EventCallback.registerNotification("node-leave");
    }

    public void taskCreate() {
        EventCallback.registerNotification("task-create");
    }

    public void taskEnd() {
        EventCallback.registerNotification("task-end");
    }

    public void timerCreate() {
        EventCallback.registerNotification("timer-create");
    }

    public void timer() {
        EventCallback.registerNotification("timer");
    }

    public void transition() {
        EventCallback.registerNotification("transition");
    }

    private static void registerNotification(final String event) {
        Synchronization notification = new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                if (status == 3) {
                    log.debug((Object)("sending '" + event + "' notification"));
                    Semaphore eventSemaphore = EventCallback.getEventSemaphore(event);
                    eventSemaphore.release();
                }
            }
        };
        JbpmContext.getCurrentJbpmContext().getSession().getTransaction().registerSynchronization(notification);
    }

    public static void waitForEvent(String event) {
        EventCallback.waitForEvent(event, 30000L);
    }

    public static void waitForEvent(String event, long timeout) {
        log.debug((Object)("waiting for " + event));
        Semaphore eventSemaphore = EventCallback.getEventSemaphore(event);
        try {
            if (eventSemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS)) {
                log.debug((Object)("received '" + event + "' notification"));
            } else {
                log.warn((Object)("event '" + event + "' did not occur within " + timeout + " ms"));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Semaphore getEventSemaphore(String event) {
        Map<String, Semaphore> map = eventSemaphores;
        synchronized (map) {
            Semaphore semaphore = eventSemaphores.get(event);
            if (semaphore == null) {
                semaphore = new Semaphore(0);
                eventSemaphores.put(event, semaphore);
            }
            return semaphore;
        }
    }

    public static void clear() {
        for (Map.Entry<String, Semaphore> entry : eventSemaphores.entrySet()) {
            int permits = entry.getValue().drainPermits();
            if (permits == 0) continue;
            log.warn((Object)("event '" + entry.getKey() + "' has " + permits + " outstanding notifications"));
        }
    }
}

