/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.db.ContextSession;
import org.jbpm.db.GraphSession;
import org.jbpm.db.JobSession;
import org.jbpm.db.LoggingSession;
import org.jbpm.db.TaskMgmtSession;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.security.AuthenticationService;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.svc.Services;
import org.jbpm.taskmgmt.exe.TaskInstance;
import org.jbpm.tx.TxService;

public class JbpmContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_JBPM_CONTEXT_NAME = "default.jbpm.context";
    static ThreadLocal currentContextsStack = new ThreadLocal();
    ObjectFactory objectFactory = null;
    Services services = null;
    List autoSaveProcessInstances = null;
    JbpmConfiguration jbpmConfiguration = null;
    private static Log log = LogFactory.getLog(JbpmContext.class);

    public JbpmContext(Services services, ObjectFactory objectFactory) {
        log.debug((Object)("creating " + this.toString()));
        this.services = services;
        this.objectFactory = objectFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block7: {
            log.debug((Object)("closing jbpmContext " + this.toString()));
            try {
                if (this.services == null) break block7;
                try {
                    this.autoSave();
                }
                finally {
                    this.services.close();
                }
            }
            finally {
                if (this.jbpmConfiguration != null) {
                    this.jbpmConfiguration.jbpmContextClosed(this);
                }
            }
        }
    }

    public static JbpmContext getCurrentJbpmContext() {
        JbpmContext currentJbpmContext = null;
        JbpmConfiguration currentJbpmConfiguration = JbpmConfiguration.getCurrentJbpmConfiguration();
        if (currentJbpmConfiguration != null) {
            currentJbpmContext = currentJbpmConfiguration.getCurrentJbpmContext();
        }
        return currentJbpmContext;
    }

    public void deployProcessDefinition(ProcessDefinition processDefinition) {
        this.getGraphSession().deployProcessDefinition(processDefinition);
    }

    public List getTaskList() {
        String actorId = this.getActorId();
        return this.getTaskMgmtSession().findTaskInstances(actorId);
    }

    public List getTaskList(String actorId) {
        return this.getTaskMgmtSession().findTaskInstances(actorId);
    }

    public List getGroupTaskList(List actorIds) {
        return this.getTaskMgmtSession().findPooledTaskInstances(actorIds);
    }

    public TaskInstance loadTaskInstance(long taskInstanceId) {
        return this.getTaskMgmtSession().loadTaskInstance(taskInstanceId);
    }

    public TaskInstance getTaskInstance(long taskInstanceId) {
        return this.getTaskMgmtSession().getTaskInstance(taskInstanceId);
    }

    public TaskInstance loadTaskInstanceForUpdate(long taskInstanceId) {
        TaskInstance taskInstance = this.getTaskMgmtSession().loadTaskInstance(taskInstanceId);
        this.addAutoSaveTaskInstance(taskInstance);
        return taskInstance;
    }

    public TaskInstance getTaskInstanceForUpdate(long taskInstanceId) {
        TaskInstance taskInstance = this.getTaskMgmtSession().getTaskInstance(taskInstanceId);
        if (taskInstance != null) {
            this.addAutoSaveTaskInstance(taskInstance);
        }
        return taskInstance;
    }

    public Token loadToken(long tokenId) {
        return this.getGraphSession().loadToken(tokenId);
    }

    public Token getToken(long tokenId) {
        return this.getGraphSession().getToken(tokenId);
    }

    public Token loadTokenForUpdate(long tokenId) {
        Token token = this.getGraphSession().loadToken(tokenId);
        this.addAutoSaveToken(token);
        return token;
    }

    public Token getTokenForUpdate(long tokenId) {
        Token token = this.getGraphSession().getToken(tokenId);
        if (token != null) {
            this.addAutoSaveToken(token);
        }
        return token;
    }

    public ProcessInstance loadProcessInstance(long processInstanceId) {
        return this.getGraphSession().loadProcessInstance(processInstanceId);
    }

    public ProcessInstance getProcessInstance(long processInstanceId) {
        return this.getGraphSession().getProcessInstance(processInstanceId);
    }

    public ProcessInstance loadProcessInstanceForUpdate(long processInstanceId) {
        ProcessInstance processInstance = this.getGraphSession().loadProcessInstance(processInstanceId);
        this.addAutoSaveProcessInstance(processInstance);
        return processInstance;
    }

    public ProcessInstance getProcessInstanceForUpdate(long processInstanceId) {
        ProcessInstance processInstance = this.getGraphSession().getProcessInstance(processInstanceId);
        if (processInstance != null) {
            this.addAutoSaveProcessInstance(processInstance);
        }
        return processInstance;
    }

    public ProcessInstance getProcessInstance(ProcessDefinition processDefinition, String key) {
        return this.getGraphSession().getProcessInstance(processDefinition, key);
    }

    public ProcessInstance loadProcessInstance(ProcessDefinition processDefinition, String key) {
        return this.getGraphSession().loadProcessInstance(processDefinition, key);
    }

    public ProcessInstance getProcessInstanceForUpdate(ProcessDefinition processDefinition, String key) {
        ProcessInstance processInstance = this.getGraphSession().getProcessInstance(processDefinition, key);
        if (processInstance != null) {
            this.addAutoSaveProcessInstance(processInstance);
        }
        return processInstance;
    }

    public ProcessInstance loadProcessInstanceForUpdate(ProcessDefinition processDefinition, String key) {
        ProcessInstance processInstance = this.getGraphSession().loadProcessInstance(processDefinition, key);
        if (processInstance != null) {
            this.addAutoSaveProcessInstance(processInstance);
        }
        return processInstance;
    }

    public ProcessInstance newProcessInstance(String processDefinitionName) {
        ProcessDefinition processDefinition = this.getGraphSession().findLatestProcessDefinition(processDefinitionName);
        return new ProcessInstance(processDefinition);
    }

    public ProcessInstance newProcessInstanceForUpdate(String processDefinitionName) {
        ProcessDefinition processDefinition = this.getGraphSession().findLatestProcessDefinition(processDefinitionName);
        ProcessInstance processInstance = new ProcessInstance(processDefinition);
        this.addAutoSaveProcessInstance(processInstance);
        return processInstance;
    }

    public void save(ProcessInstance processInstance) {
        if (this.services != null) {
            this.services.save(processInstance, this);
        }
    }

    public void save(Token token) {
        this.save(token.getProcessInstance());
    }

    public void save(TaskInstance taskInstance) {
        this.save(taskInstance.getTaskMgmtInstance().getProcessInstance());
    }

    public void setRollbackOnly() {
        TxService txService;
        TxService txService2 = txService = this.services != null ? this.services.getTxService() : null;
        if (txService == null) {
            throw new JbpmException("no transaction service configured");
        }
        txService.setRollbackOnly();
    }

    public Services getServices() {
        return this.services;
    }

    public ServiceFactory getServiceFactory(String name) {
        return this.services.getServiceFactory(name);
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public SessionFactory getSessionFactory() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService instanceof DbPersistenceService ? ((DbPersistenceService)persistenceService).getSessionFactory() : null;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService instanceof DbPersistenceService) {
            DbPersistenceService dbPersistenceService = (DbPersistenceService)persistenceService;
            dbPersistenceService.setSessionFactory(sessionFactory);
        }
    }

    public Session getSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService instanceof DbPersistenceService ? ((DbPersistenceService)persistenceService).getSession() : null;
    }

    public void setSession(Session session) {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService instanceof DbPersistenceService) {
            DbPersistenceService dbPersistenceService = (DbPersistenceService)persistenceService;
            dbPersistenceService.setSession(session);
        }
    }

    public Connection getConnection() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService instanceof DbPersistenceService ? ((DbPersistenceService)persistenceService).getConnection() : null;
    }

    public void setConnection(Connection connection) {
        PersistenceService persistenceService = this.getPersistenceService();
        if (persistenceService instanceof DbPersistenceService) {
            DbPersistenceService dbPersistenceService = (DbPersistenceService)persistenceService;
            dbPersistenceService.setConnection(connection);
        }
    }

    public ContextSession getContextSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService != null ? persistenceService.getContextSession() : null;
    }

    public LoggingSession getLoggingSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService != null ? persistenceService.getLoggingSession() : null;
    }

    public JobSession getJobSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService != null ? persistenceService.getJobSession() : null;
    }

    public GraphSession getGraphSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService != null ? persistenceService.getGraphSession() : null;
    }

    public TaskMgmtSession getTaskMgmtSession() {
        PersistenceService persistenceService = this.getPersistenceService();
        return persistenceService != null ? persistenceService.getTaskMgmtSession() : null;
    }

    public String getActorId() {
        return this.services.getAuthenticationService().getActorId();
    }

    public void setActorId(String actorId) {
        AuthenticationService authenticationService = this.services.getAuthenticationService();
        authenticationService.setActorId(actorId);
    }

    public void addAutoSaveProcessInstance(ProcessInstance processInstance) {
        if (this.autoSaveProcessInstances == null) {
            this.autoSaveProcessInstances = new ArrayList();
        }
        this.autoSaveProcessInstances.add(processInstance);
    }

    public void addAutoSaveToken(Token token) {
        this.addAutoSaveProcessInstance(token.getProcessInstance());
    }

    public void addAutoSaveTaskInstance(TaskInstance taskInstance) {
        this.addAutoSaveProcessInstance(taskInstance.getTaskMgmtInstance().getProcessInstance());
    }

    void autoSave() {
        if (this.autoSaveProcessInstances != null) {
            Iterator iter = this.autoSaveProcessInstances.iterator();
            while (iter.hasNext()) {
                ProcessInstance processInstance = (ProcessInstance)iter.next();
                this.save(processInstance);
                iter.remove();
            }
        }
    }

    PersistenceService getPersistenceService() {
        return this.services != null ? this.services.getPersistenceService() : null;
    }

    public JbpmConfiguration getJbpmConfiguration() {
        return this.jbpmConfiguration;
    }
}

