/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.util.ConfigHelper;

public class JbpmSchemaTask
extends Task {
    String config;
    String properties;
    String action;
    String output;
    String delimiter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        List exceptions;
        block12: {
            if (this.action == null) {
                this.action = "create";
            }
            if (this.config == null) {
                this.config = "hibernate.cfg.xml";
            }
            exceptions = null;
            try {
                SchemaExport schemaExport;
                Configuration configuration = this.getConfiguration();
                if ("drop".equalsIgnoreCase(this.action)) {
                    schemaExport = this.getSchemaExport(configuration);
                    schemaExport.execute(false, false, true, false);
                    exceptions = schemaExport.getExceptions();
                    break block12;
                }
                if ("create".equalsIgnoreCase(this.action)) {
                    schemaExport = this.getSchemaExport(configuration);
                    schemaExport.execute(false, false, false, true);
                    exceptions = schemaExport.getExceptions();
                    break block12;
                }
                if ("update".equalsIgnoreCase(this.action)) {
                    PrintStream sysout = System.out;
                    try {
                        if (this.output != null) {
                            PrintStream prstr = new PrintStream(new FileOutputStream(this.output));
                            System.setOut(prstr);
                        }
                        SchemaUpdate schemaUpdate = this.getSchemaUpdate(configuration);
                        schemaUpdate.execute(true, false);
                        exceptions = schemaUpdate.getExceptions();
                        break block12;
                    }
                    finally {
                        System.setOut(sysout);
                    }
                }
                throw new IllegalArgumentException("Unsupported action: " + this.action);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        for (Exception ex : exceptions) {
            this.log(ex.toString());
        }
    }

    private Configuration getConfiguration() throws IOException {
        this.log("Action '" + this.action + "' using " + this.config + "," + this.properties);
        Configuration configuration = new Configuration();
        configuration.configure(this.config);
        if (this.properties != null) {
            InputStream inStream = ConfigHelper.getResourceAsStream((String)this.properties);
            if (inStream == null) {
                throw new IllegalArgumentException("Cannot read properties: " + this.properties);
            }
            Properties properties = new Properties();
            properties.load(inStream);
            configuration.setProperties(properties);
        }
        return configuration;
    }

    private SchemaExport getSchemaExport(Configuration configuration) {
        SchemaExport schemaExport = new SchemaExport(configuration);
        if (this.output != null) {
            schemaExport.setOutputFile(this.output);
        }
        if (this.delimiter != null) {
            schemaExport.setDelimiter(this.delimiter);
        }
        schemaExport.setFormat(false);
        return schemaExport;
    }

    private SchemaUpdate getSchemaUpdate(Configuration configuration) {
        SchemaUpdate schemaUpdate = new SchemaUpdate(configuration);
        return schemaUpdate;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setOutput(String output) {
        this.output = output;
    }
}

