/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ValueInfo;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.instantiation.DefaultProcessClassLoaderFactory;
import org.jbpm.instantiation.ProcessClassLoaderFactory;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.util.ClassLoaderUtil;

public class JbpmConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    static ObjectFactory defaultObjectFactory;
    static final Map<String, JbpmConfiguration> instances;
    static final ThreadLocal<List<JbpmConfiguration>> jbpmConfigurationStacks;
    private final ObjectFactory objectFactory;
    private final ThreadLocal<List<JbpmContext>> jbpmContextStacks = new StackThreadLocal<JbpmContext>();
    private JobExecutor jobExecutor;
    private boolean isClosed;
    private static Log log;

    static {
        instances = new HashMap<String, JbpmConfiguration>();
        jbpmConfigurationStacks = new StackThreadLocal<JbpmConfiguration>();
        log = LogFactory.getLog(JbpmConfiguration.class);
    }

    public JbpmConfiguration(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public static JbpmConfiguration getInstance() {
        return JbpmConfiguration.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JbpmConfiguration getInstance(String resource) {
        JbpmConfiguration instance;
        if (resource == null) {
            resource = "jbpm.cfg.xml";
        }
        Map<String, JbpmConfiguration> map = instances;
        synchronized (map) {
            instance = instances.get(resource);
            if (instance == null) {
                if (defaultObjectFactory != null) {
                    log.debug((Object)("creating configuration from default object factory: " + defaultObjectFactory));
                    instance = new JbpmConfiguration(defaultObjectFactory);
                } else {
                    log.info((Object)("using configuration resource: " + resource));
                    InputStream jbpmCfgXmlStream = ClassLoaderUtil.getJbpmConfigurationStream(resource);
                    if (jbpmCfgXmlStream == null && !"jbpm.cfg.xml".equals(resource)) {
                        log.warn((Object)("configuration resource '" + resource + "' could not be found"));
                    }
                    ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(jbpmCfgXmlStream);
                    instance = JbpmConfiguration.createJbpmConfiguration(objectFactory);
                }
                instances.put(resource, instance);
            }
        }
        return instance;
    }

    public static boolean hasInstance(String resource) {
        return instances.containsKey(resource != null ? resource : "jbpm.cfg.xml");
    }

    protected static ObjectFactory parseObjectFactory(InputStream inputStream) {
        log.debug((Object)"loading defaults in jbpm configuration");
        ObjectFactoryParser objectFactoryParser = new ObjectFactoryParser();
        ObjectFactoryImpl objectFactoryImpl = new ObjectFactoryImpl();
        objectFactoryParser.parseElementsFromResource("org/jbpm/default.jbpm.cfg.xml", objectFactoryImpl);
        if (inputStream != null) {
            log.debug((Object)"loading specific configuration...");
            objectFactoryParser.parseElementsStream(inputStream, objectFactoryImpl);
        }
        return objectFactoryImpl;
    }

    public static JbpmConfiguration parseXmlString(String xml) {
        log.debug((Object)"creating jbpm configuration from xml string");
        ByteArrayInputStream inputStream = null;
        if (xml != null) {
            inputStream = new ByteArrayInputStream(xml.getBytes());
        }
        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        return JbpmConfiguration.createJbpmConfiguration(objectFactory);
    }

    protected static JbpmConfiguration createJbpmConfiguration(ObjectFactory objectFactory) {
        JbpmConfiguration jbpmConfiguration = new JbpmConfiguration(objectFactory);
        if (objectFactory instanceof ObjectFactoryImpl) {
            ObjectFactoryImpl objectFactoryImpl = (ObjectFactoryImpl)objectFactory;
            ValueInfo jbpmConfigurationInfo = new ValueInfo("jbpmConfiguration", jbpmConfiguration);
            objectFactoryImpl.addObjectInfo(jbpmConfigurationInfo);
            if (JbpmConfiguration.getHideStaleObjectExceptions(objectFactory)) {
                StaleObjectLogConfigurer.hideStaleObjectExceptions();
            }
        }
        return jbpmConfiguration;
    }

    private static boolean getHideStaleObjectExceptions(ObjectFactory objectFactory) {
        if (!objectFactory.hasObject("jbpm.hide.stale.object.exceptions")) {
            return true;
        }
        Object object = objectFactory.createObject("jbpm.hide.stale.object.exceptions");
        return object instanceof Boolean ? (Boolean)object : true;
    }

    public static JbpmConfiguration parseInputStream(InputStream inputStream) {
        log.debug((Object)"creating jbpm configuration from input stream");
        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        return JbpmConfiguration.createJbpmConfiguration(objectFactory);
    }

    public static JbpmConfiguration parseResource(String resource) {
        log.debug((Object)("creating jbpm configuration from resource: " + resource));
        InputStream inputStream = null;
        if (resource != null) {
            inputStream = ClassLoaderUtil.getJbpmConfigurationStream(resource);
        }
        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        return JbpmConfiguration.createJbpmConfiguration(objectFactory);
    }

    public JbpmContext createJbpmContext() {
        return this.createJbpmContext("default.jbpm.context");
    }

    public JbpmContext createJbpmContext(String name) {
        this.ensureOpen();
        JbpmContext jbpmContext = (JbpmContext)this.objectFactory.createObject(name);
        jbpmContext.jbpmConfiguration = this;
        this.jbpmContextCreated(jbpmContext);
        return jbpmContext;
    }

    private void ensureOpen() {
        if (this.isClosed) {
            throw new JbpmException("configuration closed");
        }
    }

    public ServiceFactory getServiceFactory(String serviceName) {
        return this.getServiceFactory(serviceName, "default.jbpm.context");
    }

    public ServiceFactory getServiceFactory(String serviceName, String jbpmContextName) {
        ServiceFactory serviceFactory = null;
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            serviceFactory = jbpmContext.getServices().getServiceFactory(serviceName);
        }
        finally {
            jbpmContext.close();
        }
        return serviceFactory;
    }

    public static ClassLoader getProcessClassLoader(ProcessDefinition processDefinition) {
        ProcessClassLoaderFactory factory = null;
        factory = Configs.hasObject("jbpm.processClassLoader") ? (ProcessClassLoaderFactory)Configs.getObject("jbpm.processClassLoader") : new DefaultProcessClassLoaderFactory();
        return factory.getProcessClassLoader(processDefinition);
    }

    public void cleanSchema() {
        this.cleanSchema("default.jbpm.context");
    }

    public void cleanSchema(String jbpmContextName) {
        this.getPersistenceServiceFactory(jbpmContextName).cleanSchema();
    }

    public void createSchema() {
        this.createSchema("default.jbpm.context");
    }

    public void createSchema(String jbpmContextName) {
        this.getPersistenceServiceFactory(jbpmContextName).createSchema();
    }

    public void dropSchema() {
        this.dropSchema("default.jbpm.context");
    }

    public void dropSchema(String jbpmContextName) {
        this.getPersistenceServiceFactory(jbpmContextName).dropSchema();
    }

    private DbPersistenceServiceFactory getPersistenceServiceFactory(String jbpmContextName) {
        return (DbPersistenceServiceFactory)this.getServiceFactory("persistence", jbpmContextName);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() {
        this.close("default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String jbpmContextName) {
        if (this.isClosed) {
            return;
        }
        if (this.jobExecutor != null) {
            this.jobExecutor.stop();
            this.jobExecutor = null;
        }
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            Map<String, ServiceFactory> serviceFactories = jbpmContext.getServices().getServiceFactories();
            if (serviceFactories != null) {
                for (ServiceFactory serviceFactory : serviceFactories.values()) {
                    serviceFactory.close();
                }
            }
        }
        finally {
            jbpmContext.close();
        }
        this.isClosed = true;
        this.jbpmContextStacks.remove();
        Map<String, JbpmConfiguration> map = instances;
        synchronized (map) {
            Iterator<JbpmConfiguration> i = instances.values().iterator();
            while (i.hasNext()) {
                if (this != i.next()) continue;
                i.remove();
                break;
            }
        }
    }

    static JbpmConfiguration getCurrentJbpmConfiguration() {
        JbpmConfiguration currentJbpmConfiguration = null;
        List<JbpmConfiguration> stack = JbpmConfiguration.getJbpmConfigurationStack();
        if (!stack.isEmpty()) {
            currentJbpmConfiguration = stack.get(stack.size() - 1);
        }
        return currentJbpmConfiguration;
    }

    static List<JbpmConfiguration> getJbpmConfigurationStack() {
        return jbpmConfigurationStacks.get();
    }

    static void clearJbpmConfigurationStack() {
        List<JbpmConfiguration> configStack = JbpmConfiguration.getJbpmConfigurationStack();
        if (configStack != null) {
            for (JbpmConfiguration config : new ArrayList<JbpmConfiguration>(configStack)) {
                List<JbpmContext> contextStack = config.getJbpmContextStack();
                if (contextStack != null) {
                    for (JbpmContext context : new ArrayList<JbpmContext>(contextStack)) {
                        context.close();
                    }
                }
                contextStack.clear();
            }
            configStack.clear();
        }
    }

    synchronized void pushJbpmConfiguration() {
        JbpmConfiguration.getJbpmConfigurationStack().add(this);
    }

    synchronized void popJbpmConfiguration() {
        JbpmConfiguration.getJbpmConfigurationStack().remove(this);
    }

    public JbpmContext getCurrentJbpmContext() {
        this.ensureOpen();
        JbpmContext currentJbpmContext = null;
        List<JbpmContext> stack = this.getJbpmContextStack();
        if (!stack.isEmpty()) {
            currentJbpmContext = stack.get(stack.size() - 1);
        }
        return currentJbpmContext;
    }

    List<JbpmContext> getJbpmContextStack() {
        return this.jbpmContextStacks.get();
    }

    void pushJbpmContext(JbpmContext jbpmContext) {
        this.getJbpmContextStack().add(jbpmContext);
    }

    void popJbpmContext(JbpmContext jbpmContext) {
        List<JbpmContext> stack = this.getJbpmContextStack();
        int size = stack.size();
        if (size == 0) {
            log.warn((Object)"closed JbpmContext more than once... check your try-finally clauses around JbpmContext blocks");
        } else if (jbpmContext != stack.remove(size - 1)) {
            stack.remove(jbpmContext);
            log.warn((Object)"closed JbpmContext in some order that differs from creation... check your try-finally clauses around JbpmContext blocks");
        }
    }

    void jbpmContextCreated(JbpmContext jbpmContext) {
        this.pushJbpmConfiguration();
        this.pushJbpmContext(jbpmContext);
    }

    void jbpmContextClosed(JbpmContext jbpmContext) {
        this.popJbpmContext(jbpmContext);
        this.popJbpmConfiguration();
    }

    public void startJobExecutor() {
        this.getJobExecutor().start();
    }

    public synchronized JobExecutor getJobExecutor() {
        this.ensureOpen();
        if (this.jobExecutor == null) {
            Object object = this.objectFactory.createObject("jbpm.job.executor");
            if (object instanceof JobExecutor) {
                this.jobExecutor = (JobExecutor)object;
            } else if (object != null) {
                throw new JbpmException("configuration object named 'jbpm.job.executor' is not a " + JobExecutor.class.getSimpleName());
            }
        }
        return this.jobExecutor;
    }

    public static class Configs {
        private Configs() {
        }

        public static ObjectFactory getObjectFactory() {
            ObjectFactory objectFactory = null;
            JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
            objectFactory = jbpmContext != null ? jbpmContext.objectFactory : JbpmConfiguration.getInstance().objectFactory;
            return objectFactory;
        }

        public static void setDefaultObjectFactory(ObjectFactory objectFactory) {
            defaultObjectFactory = objectFactory;
        }

        public static boolean hasObject(String name) {
            ObjectFactory objectFactory = Configs.getObjectFactory();
            return objectFactory.hasObject(name);
        }

        public static synchronized Object getObject(String name) {
            ObjectFactory objectFactory = Configs.getObjectFactory();
            return objectFactory.createObject(name);
        }

        public static String getString(String name) {
            return (String)Configs.getObject(name);
        }

        public static long getLong(String name) {
            return (Long)Configs.getObject(name);
        }

        public static int getInt(String name) {
            return (Integer)Configs.getObject(name);
        }

        public static boolean getBoolean(String name) {
            return (Boolean)Configs.getObject(name);
        }
    }

    static class StackThreadLocal<E>
    extends ThreadLocal<List<E>> {
        StackThreadLocal() {
        }

        @Override
        protected List<E> initialValue() {
            return new ArrayList();
        }
    }
}

