/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.util.ConfigHelper;
import org.jbpm.db.compatibility.JbpmSchemaUpdate;
import org.jbpm.util.CollectionUtil;

public class JbpmSchemaTask
extends Task {
    String config;
    String properties;
    String action;
    String output;
    String delimiter;

    public void execute() throws BuildException {
        List<Exception> exceptions;
        block8: {
            if (this.action == null) {
                this.action = "create";
            }
            if (this.config == null) {
                this.config = "hibernate.cfg.xml";
            }
            try {
                SchemaExport schemaExport;
                Configuration configuration = this.getConfiguration();
                if ("drop".equalsIgnoreCase(this.action)) {
                    schemaExport = this.getSchemaExport(configuration);
                    schemaExport.drop(false, false);
                    exceptions = CollectionUtil.checkList(schemaExport.getExceptions(), Exception.class);
                    break block8;
                }
                if ("create".equalsIgnoreCase(this.action)) {
                    schemaExport = this.getSchemaExport(configuration);
                    schemaExport.execute(false, false, false, true);
                    exceptions = CollectionUtil.checkList(schemaExport.getExceptions(), Exception.class);
                    break block8;
                }
                if ("update".equalsIgnoreCase(this.action)) {
                    JbpmSchemaUpdate schemaUpdate = this.getSchemaUpdate(configuration);
                    schemaUpdate.execute(false, false);
                    exceptions = schemaUpdate.getExceptions();
                    break block8;
                }
                throw new BuildException("Unsupported action: " + this.action);
            }
            catch (IOException iOException) {
                exceptions = Collections.singletonList(iOException);
            }
        }
        for (Exception exception : exceptions) {
            this.log(exception.getMessage(), 0);
        }
    }

    private Configuration getConfiguration() throws IOException {
        this.log("Action '" + this.action + "' using " + this.config + ", " + this.properties);
        Configuration configuration = new Configuration();
        configuration.configure(this.config);
        if (this.properties != null) {
            InputStream inStream = ConfigHelper.getResourceAsStream((String)this.properties);
            if (inStream == null) {
                throw new FileNotFoundException("Could not find properties: " + this.properties);
            }
            try {
                Properties properties = new Properties();
                properties.load(inStream);
                configuration.addProperties(properties);
            }
            finally {
                inStream.close();
            }
        }
        return configuration;
    }

    private SchemaExport getSchemaExport(Configuration configuration) {
        SchemaExport schemaExport = new SchemaExport(configuration);
        if (this.output != null) {
            schemaExport.setOutputFile(this.output);
        }
        if (this.delimiter != null) {
            schemaExport.setDelimiter(this.delimiter);
        }
        schemaExport.setFormat(false);
        return schemaExport;
    }

    private JbpmSchemaUpdate getSchemaUpdate(Configuration configuration) {
        JbpmSchemaUpdate schemaUpdate = new JbpmSchemaUpdate(configuration);
        if (this.output != null) {
            schemaUpdate.setOutputFile(new File(this.output));
        }
        if (this.delimiter != null) {
            schemaUpdate.setDelimiter(this.delimiter);
        }
        return schemaUpdate;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setOutput(String output) {
        this.output = output;
    }
}

