/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.configuration.AbstractObjectInfo;
import org.jbpm.configuration.BeanInfo;
import org.jbpm.configuration.ConfigurationException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.svc.Services;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class JbpmContextInfo
extends AbstractObjectInfo {
    private static final long serialVersionUID = 1L;
    Map serviceFactoryObjectInfos = null;
    Map serviceFactories = null;
    List serviceNames = null;
    ObjectInfo[] saveOperationObjectInfos = null;
    List saveOperations = null;
    private static Log log = LogFactory.getLog(JbpmContextInfo.class);

    public JbpmContextInfo(Element jbpmContextElement, ObjectFactoryParser objectFactoryParser) {
        super(JbpmContextInfo.verifyDefaultName(jbpmContextElement), objectFactoryParser);
        BeanInfo beanInfo;
        if (jbpmContextElement.hasAttribute("singleton")) {
            throw new ConfigurationException("attribute 'singleton' is not allowed in element 'jbpm-context'");
        }
        this.serviceFactoryObjectInfos = new HashMap();
        List<Element> serviceElements = XmlUtil.elements(jbpmContextElement, "service");
        this.serviceNames = new ArrayList();
        for (Element serviceElement : serviceElements) {
            if (!serviceElement.hasAttribute("name")) {
                throw new ConfigurationException("name is required in service element " + XmlUtil.toString(serviceElement));
            }
            String serviceName = serviceElement.getAttribute("name");
            this.serviceNames.add(serviceName);
            ObjectInfo serviceFactoryObjectInfo = null;
            Element factoryElement = XmlUtil.element(serviceElement, "factory");
            if (factoryElement != null) {
                Element factoryBeanElement = XmlUtil.element(factoryElement);
                if (factoryBeanElement == null) {
                    throw new ConfigurationException("element 'factory' requires either a bean or ref element");
                }
                serviceFactoryObjectInfo = objectFactoryParser.parse(factoryBeanElement);
                if (serviceElement.hasAttribute("factory")) {
                    log.warn((Object)("duplicate factory specification for service " + serviceName + ", using the factory element"));
                }
            } else if (serviceElement.hasAttribute("factory")) {
                String factoryClassName = serviceElement.getAttribute("factory");
                beanInfo = new BeanInfo();
                beanInfo.setClassName(factoryClassName);
                serviceFactoryObjectInfo = beanInfo;
            } else {
                throw new ConfigurationException("element 'service' requires either a factory attribute or a factory element");
            }
            this.serviceFactoryObjectInfos.put(serviceName, serviceFactoryObjectInfo);
        }
        Element saveOperationsElement = XmlUtil.element(jbpmContextElement, "save-operations");
        if (saveOperationsElement != null) {
            List<Element> saveOperationElements = XmlUtil.elements(saveOperationsElement, "save-operation");
            this.saveOperationObjectInfos = new ObjectInfo[saveOperationElements.size()];
            int i = 0;
            while (i < saveOperationElements.size()) {
                Element saveOperationElement = saveOperationElements.get(i);
                if (saveOperationElement.hasAttribute("class")) {
                    String saveOperationClassName = saveOperationElement.getAttribute("class");
                    beanInfo = new BeanInfo();
                    beanInfo.setClassName(saveOperationClassName);
                    this.saveOperationObjectInfos[i] = beanInfo;
                } else {
                    Element saveOperationBeanElement = XmlUtil.element(saveOperationElement);
                    if (saveOperationBeanElement == null) {
                        throw new ConfigurationException("element 'save-operation' requires either a class attribute or an element of type 'bean' or 'ref'");
                    }
                    this.saveOperationObjectInfos[i] = objectFactoryParser.parse(saveOperationBeanElement);
                }
                ++i;
            }
        }
    }

    static Element verifyDefaultName(Element jbpmContextElement) {
        if (!jbpmContextElement.hasAttribute("name")) {
            jbpmContextElement.setAttribute("name", "default.jbpm.context");
        }
        return jbpmContextElement;
    }

    @Override
    public synchronized Object createObject(ObjectFactoryImpl objectFactory) {
        if (this.serviceFactories == null) {
            this.serviceFactories = new HashMap();
            for (Map.Entry entry : this.serviceFactoryObjectInfos.entrySet()) {
                String serviceName = (String)entry.getKey();
                ObjectInfo serviceFactoryObjectInfo = (ObjectInfo)entry.getValue();
                this.serviceFactories.put(serviceName, serviceFactoryObjectInfo.createObject(objectFactory));
            }
        }
        if (this.saveOperations == null && this.saveOperationObjectInfos != null) {
            this.saveOperations = new ArrayList();
            int i = 0;
            while (i < this.saveOperationObjectInfos.length) {
                Object saveOperation = this.saveOperationObjectInfos[i].createObject(objectFactory);
                this.saveOperations.add(saveOperation);
                ++i;
            }
        }
        Services services = new Services(this.serviceFactories, this.serviceNames, this.saveOperations);
        if (log.isDebugEnabled()) {
            log.debug((Object)("creating jbpm context with service factories '" + this.serviceFactories.keySet() + "'"));
        }
        return new JbpmContext(services, objectFactory);
    }
}

