/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.configuration.AbstractObjectInfo;
import org.jbpm.configuration.ConfigurationException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.context.exe.Converter;
import org.jbpm.context.exe.JbpmType;
import org.jbpm.context.exe.JbpmTypeMatcher;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.db.hibernate.Converters;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class JbpmTypeObjectInfo
extends AbstractObjectInfo {
    private static final long serialVersionUID = 1L;
    ObjectInfo typeMatcherObjectInfo = null;
    Converter<?, ?> converter = null;
    Class<? extends VariableInstance> variableInstanceClass = null;
    private static Log log = LogFactory.getLog(JbpmTypeObjectInfo.class);

    public JbpmTypeObjectInfo(Element jbpmTypeElement, ObjectFactoryParser objectFactoryParser) {
        super(jbpmTypeElement, objectFactoryParser);
        try {
            Element variableInstanceElement;
            Element typeMatcherElement = XmlUtil.element(jbpmTypeElement, "matcher");
            if (typeMatcherElement == null) {
                throw new ConfigurationException("matcher element is required in <jbpm-type>: " + XmlUtil.toString(jbpmTypeElement));
            }
            Element typeMatcherBeanElement = XmlUtil.element(typeMatcherElement);
            this.typeMatcherObjectInfo = objectFactoryParser.parse(typeMatcherBeanElement);
            Element converterElement = XmlUtil.element(jbpmTypeElement, "converter");
            if (converterElement != null) {
                if (!converterElement.hasAttribute("class")) {
                    throw new ConfigurationException("class attribute is required in <converter>: " + XmlUtil.toString(jbpmTypeElement));
                }
                String converterClassName = converterElement.getAttribute("class");
                this.converter = Converters.getConverterByClassName(converterClassName);
            }
            if (!(variableInstanceElement = XmlUtil.element(jbpmTypeElement, "variable-instance")).hasAttribute("class")) {
                throw new ConfigurationException("class attribute is required in <variable-instance>: " + XmlUtil.toString(jbpmTypeElement));
            }
            String variableInstanceClassName = variableInstanceElement.getAttribute("class");
            this.variableInstanceClass = ClassLoaderUtil.classForName(variableInstanceClassName).asSubclass(VariableInstance.class);
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (RuntimeException e) {
            log.debug((Object)("could not instantiate jbpm type '" + XmlUtil.toString(jbpmTypeElement) + "': " + e));
            this.typeMatcherObjectInfo = NoObjectInfo.getInstance();
            this.converter = null;
            this.variableInstanceClass = null;
        }
    }

    @Override
    public Object createObject(ObjectFactoryImpl objectFactory) {
        JbpmTypeMatcher jbpmTypeMatcher = (JbpmTypeMatcher)objectFactory.createObject(this.typeMatcherObjectInfo);
        return new JbpmType(jbpmTypeMatcher, this.converter, this.variableInstanceClass);
    }

    static class NoObjectInfo
    implements ObjectInfo {
        private static final long serialVersionUID = 1L;
        private static ObjectInfo instance;

        private NoObjectInfo() {
        }

        @Override
        public boolean hasName() {
            return false;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }

        @Override
        public Object createObject(ObjectFactoryImpl objectFactory) {
            return NoTypeMatcher.getInstance();
        }

        static ObjectInfo getInstance() {
            if (instance == null) {
                instance = new NoObjectInfo();
            }
            return instance;
        }
    }

    static class NoTypeMatcher
    implements JbpmTypeMatcher {
        private static final long serialVersionUID = 1L;
        static final JbpmTypeMatcher instance = new NoTypeMatcher();

        private NoTypeMatcher() {
        }

        @Override
        public boolean matches(Object value) {
            return false;
        }

        static JbpmTypeMatcher getInstance() {
            return instance;
        }
    }
}

