/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.util.ArrayList;
import java.util.List;
import org.jbpm.configuration.AbstractObjectInfo;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class ListInfo
extends AbstractObjectInfo {
    private static final long serialVersionUID = 1L;
    ObjectInfo[] elementInfos = null;

    public ListInfo(Element listElement, ObjectFactoryParser configParser) {
        super(listElement, configParser);
        List<Element> elementElements = XmlUtil.elements(listElement);
        this.elementInfos = new ObjectInfo[elementElements.size()];
        int i = 0;
        while (i < elementElements.size()) {
            Element elementElement = elementElements.get(i);
            this.elementInfos[i] = configParser.parse(elementElement);
            ++i;
        }
    }

    @Override
    public Object createObject(ObjectFactoryImpl objectFactory) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.elementInfos != null) {
            int i = 0;
            while (i < this.elementInfos.length) {
                Object element = objectFactory.getObject(this.elementInfos[i]);
                list.add(element);
                ++i;
            }
        }
        return list;
    }
}

