/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmException;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.util.CollectionUtil;

public class GraphSession {
    final Session session;
    final JbpmSession jbpmSession;
    private static final Log log = LogFactory.getLog(GraphSession.class);

    public GraphSession(JbpmSession jbpmSession) {
        this.session = jbpmSession.getSession();
        this.jbpmSession = jbpmSession;
    }

    public GraphSession(Session session) {
        this.session = session;
        this.jbpmSession = null;
    }

    public void deployProcessDefinition(ProcessDefinition processDefinition) {
        String processDefinitionName = processDefinition.getName();
        if (processDefinitionName != null) {
            ProcessDefinition previousLatestVersion = this.findLatestProcessDefinition(processDefinitionName);
            if (previousLatestVersion != null) {
                processDefinition.setVersion(previousLatestVersion.getVersion() + 1);
            } else {
                processDefinition.setVersion(1);
            }
        } else {
            throw new JbpmException("process definition does not have a name");
        }
        this.session.save((Object)processDefinition);
    }

    public void saveProcessDefinition(ProcessDefinition processDefinition) {
        try {
            this.session.save((Object)processDefinition);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not save " + processDefinition, e);
        }
    }

    public ProcessDefinition loadProcessDefinition(long processDefinitionId) {
        try {
            return (ProcessDefinition)this.session.load(ProcessDefinition.class, (Serializable)new Long(processDefinitionId));
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not load process definition " + processDefinitionId, e);
        }
    }

    public ProcessDefinition getProcessDefinition(long processDefinitionId) {
        try {
            return (ProcessDefinition)this.session.get(ProcessDefinition.class, (Serializable)new Long(processDefinitionId));
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not get process definition " + processDefinitionId, e);
        }
    }

    public ProcessDefinition findProcessDefinition(String name, int version) {
        try {
            return (ProcessDefinition)this.session.getNamedQuery("GraphSession.findProcessDefinitionByNameAndVersion").setString("name", name).setInteger("version", version).uniqueResult();
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not find process definition '" + name + "' at version " + version, e);
        }
    }

    public ProcessDefinition findLatestProcessDefinition(String name) {
        try {
            return (ProcessDefinition)this.session.getNamedQuery("GraphSession.findLatestProcessDefinitionQuery").setString("name", name).setMaxResults(1).uniqueResult();
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not find process definition '" + name + "'", e);
        }
    }

    public List<ProcessDefinition> findLatestProcessDefinitions() {
        try {
            List tuples = this.session.getNamedQuery("GraphSession.findLatestProcessDefinitions").list();
            ArrayList<ProcessDefinition> result = new ArrayList<ProcessDefinition>();
            for (Object[] tuple : CollectionUtil.checkList(tuples, Object[].class)) {
                String name = (String)tuple[0];
                Integer version = (Integer)tuple[1];
                result.add(this.findProcessDefinition(name, version));
            }
            return result;
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not find latest versions of process definitions", e);
        }
    }

    public List<ProcessDefinition> findProcessDefinitions(Collection<Long> processDefinitionIds) {
        List processDefinitions = this.session.createCriteria(ProcessDefinition.class).add(Restrictions.in((String)"id", processDefinitionIds)).list();
        return CollectionUtil.checkList(processDefinitions, ProcessDefinition.class);
    }

    public List<ProcessDefinition> findAllProcessDefinitions() {
        try {
            List processDefinitions = this.session.getNamedQuery("GraphSession.findAllProcessDefinitions").list();
            return CollectionUtil.checkList(processDefinitions, ProcessDefinition.class);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not find all process definitions", e);
        }
    }

    public List<ProcessDefinition> findAllProcessDefinitionVersions(String name) {
        try {
            List processDefinitions = this.session.getNamedQuery("GraphSession.findAllProcessDefinitionVersions").setString("name", name).list();
            return CollectionUtil.checkList(processDefinitions, ProcessDefinition.class);
        }
        catch (HibernateException e) {
            log.error((Object)e);
            throw new JbpmException("could not find all versions of process definition '" + name + "'", e);
        }
    }

    public void deleteProcessDefinition(long processDefinitionId) {
        this.deleteProcessDefinition(this.loadProcessDefinition(processDefinitionId));
    }

    public void deleteProcessDefinition(ProcessDefinition processDefinition) {
        if (processDefinition == null) {
            throw new IllegalArgumentException("processDefinition cannot be null");
        }
        try {
            List processInstanceIds = this.session.getNamedQuery("GraphSession.findAllProcessInstanceIdsForDefinition").setLong("processDefinitionId", processDefinition.getId()).list();
            for (Long processInstanceId : CollectionUtil.checkList(processInstanceIds, Long.class)) {
                ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
                if (processInstance != null) {
                    this.deleteProcessInstance(processInstance);
                    continue;
                }
                log.debug((Object)("process instance " + processInstanceId + " has been deleted already"));
            }
            List<ProcessState> referencingProcessStates = this.findReferencingProcessStates(processDefinition);
            for (ProcessState processState : referencingProcessStates) {
                processState.setSubProcessDefinition(null);
            }
            this.session.delete((Object)processDefinition);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not delete " + processDefinition, e);
        }
    }

    List<ProcessState> findReferencingProcessStates(ProcessDefinition subProcessDefinition) {
        List processStates = this.session.getNamedQuery("GraphSession.findReferencingProcessStates").setEntity("subProcessDefinition", (Object)subProcessDefinition).list();
        return CollectionUtil.checkList(processStates, ProcessState.class);
    }

    public void saveProcessInstance(ProcessInstance processInstance) {
        throw new UnsupportedOperationException("use JbpmContext.save(ProcessInstance) instead");
    }

    public ProcessInstance loadProcessInstance(long processInstanceId) {
        try {
            return (ProcessInstance)this.session.load(ProcessInstance.class, (Serializable)new Long(processInstanceId));
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not load process instance " + processInstanceId, e);
        }
    }

    public ProcessInstance getProcessInstance(long processInstanceId) {
        try {
            return (ProcessInstance)this.session.get(ProcessInstance.class, (Serializable)new Long(processInstanceId));
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not get process instance " + processInstanceId, e);
        }
    }

    public Token loadToken(long tokenId) {
        try {
            return (Token)this.session.load(Token.class, (Serializable)new Long(tokenId));
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not load token " + tokenId, e);
        }
    }

    public Token getToken(long tokenId) {
        try {
            return (Token)this.session.get(Token.class, (Serializable)new Long(tokenId));
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not get token " + tokenId, e);
        }
    }

    public void lockProcessInstance(long processInstanceId) {
        try {
            this.session.load(ProcessInstance.class, (Serializable)Long.valueOf(processInstanceId), LockMode.UPGRADE);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not lock process instance " + processInstanceId, e);
        }
    }

    public void lockProcessInstance(ProcessInstance processInstance) {
        try {
            this.session.lock((Object)processInstance, LockMode.UPGRADE);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not lock " + processInstance, e);
        }
    }

    public List<ProcessInstance> findProcessInstances(long processDefinitionId) {
        try {
            List processInstances = this.session.getNamedQuery("GraphSession.findAllProcessInstancesForDefinition").setLong("processDefinitionId", processDefinitionId).list();
            return CollectionUtil.checkList(processInstances, ProcessInstance.class);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not find process instances for process definition " + processDefinitionId, e);
        }
    }

    public void deleteProcessInstance(long processInstanceId) {
        this.deleteProcessInstance(this.loadProcessInstance(processInstanceId));
    }

    public void deleteProcessInstance(ProcessInstance processInstance) {
        this.deleteProcessInstance(processInstance, true, true);
    }

    public void deleteProcessInstance(ProcessInstance processInstance, boolean includeTasks, boolean includeJobs) {
        if (processInstance == null) {
            throw new IllegalArgumentException("processInstance cannot be null");
        }
        try {
            if (includeJobs) {
                log.debug((Object)("deleting jobs for " + processInstance));
                int entityCount = this.session.getNamedQuery("GraphSession.deleteJobsForProcessInstance").setEntity("processInstance", (Object)processInstance).executeUpdate();
                log.debug((Object)("deleted " + entityCount + " jobs for " + processInstance));
            }
            log.debug((Object)("deleting logs for " + processInstance));
            this.deleteLogs(processInstance);
            Token superProcessToken = processInstance.getSuperProcessToken();
            if (superProcessToken != null) {
                log.debug((Object)("detaching " + processInstance + " from super process token " + superProcessToken.getId()));
                processInstance.setSuperProcessToken(null);
                superProcessToken.setSubProcessInstance(null);
            }
            log.debug((Object)("deleting subprocesses for " + processInstance));
            this.deleteSubProcesses(processInstance);
            if (includeTasks) {
                log.debug((Object)("deleting tasks for " + processInstance));
                List tasks = this.session.getNamedQuery("GraphSession.findTaskInstancesForProcessInstance").setEntity("processInstance", (Object)processInstance).list();
                for (Object task : tasks) {
                    this.session.delete(task);
                }
            }
            log.debug((Object)("deleting " + processInstance));
            this.session.delete((Object)processInstance);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not delete " + processInstance, e);
        }
    }

    void deleteLogs(ProcessInstance processInstance) {
        List logs = this.session.getNamedQuery("GraphSession.findLogsForProcessInstance").setEntity("processInstance", (Object)processInstance).list();
        for (ProcessLog processLog : CollectionUtil.checkList(logs, ProcessLog.class)) {
            this.session.delete((Object)processLog);
        }
    }

    void deleteSubProcesses(ProcessInstance processInstance) {
        if (processInstance != null) {
            List subProcessInstances = this.session.getNamedQuery("GraphSession.findSubProcessInstances").setEntity("processInstance", (Object)processInstance).list();
            if (subProcessInstances.isEmpty()) {
                log.debug((Object)("no subprocesses to delete for " + processInstance));
                return;
            }
            for (ProcessInstance subProcessInstance : CollectionUtil.checkList(subProcessInstances, ProcessInstance.class)) {
                log.debug((Object)("preparing to delete sub process instance " + subProcessInstance.getId()));
                this.deleteProcessInstance(subProcessInstance);
            }
        }
    }

    public List<AverageNodeTimeEntry> calculateAverageTimeByNode(long processDefinitionId, long minumumDurationMillis) {
        try {
            List<AverageNodeTimeEntry> results;
            List tuples = this.session.getNamedQuery("GraphSession.calculateAverageTimeByNode").setLong("processDefinitionId", processDefinitionId).setDouble("minimumDuration", (double)minumumDurationMillis).list();
            if (!tuples.isEmpty()) {
                results = new ArrayList();
                for (Object[] values : CollectionUtil.checkList(tuples, Object[].class)) {
                    AverageNodeTimeEntry averageNodeTimeEntry = new AverageNodeTimeEntry();
                    averageNodeTimeEntry.setNodeId(((Number)values[0]).longValue());
                    averageNodeTimeEntry.setNodeName((String)values[1]);
                    averageNodeTimeEntry.setCount(((Number)values[2]).intValue());
                    averageNodeTimeEntry.setAverageDuration(((Number)values[3]).longValue());
                    averageNodeTimeEntry.setMinDuration(((Number)values[4]).longValue());
                    averageNodeTimeEntry.setMaxDuration(((Number)values[5]).longValue());
                    results.add(averageNodeTimeEntry);
                }
            } else {
                results = Collections.emptyList();
            }
            return results;
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not calculate average time by node for process definition " + processDefinitionId, e);
        }
    }

    public List<Node> findActiveNodesByProcessInstance(ProcessInstance processInstance) {
        try {
            List nodes = this.session.getNamedQuery("GraphSession.findActiveNodesByProcessInstance").setEntity("processInstance", (Object)processInstance).list();
            return CollectionUtil.checkList(nodes, Node.class);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not find active nodes for " + processInstance, e);
        }
    }

    public ProcessInstance getProcessInstance(ProcessDefinition processDefinition, String key) {
        try {
            return (ProcessInstance)this.session.getNamedQuery("GraphSession.findProcessInstanceByKey").setEntity("processDefinition", (Object)processDefinition).setString("key", key).uniqueResult();
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("could not get process instance with key '" + key + "'", e);
        }
    }

    public ProcessInstance loadProcessInstance(ProcessDefinition processDefinition, String key) {
        ProcessInstance processInstance = this.getProcessInstance(processDefinition, key);
        if (processInstance == null) {
            throw new JbpmException("no process instance was found with key '" + key + "'");
        }
        return processInstance;
    }

    private void handle(Exception e) {
        log.error((Object)e);
        if (this.jbpmSession != null) {
            this.jbpmSession.handleException();
        }
    }

    public static class AverageNodeTimeEntry {
        private long nodeId;
        private String nodeName;
        private int count;
        private long averageDuration;
        private long minDuration;
        private long maxDuration;

        public long getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(long nodeId) {
            this.nodeId = nodeId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public long getAverageDuration() {
            return this.averageDuration;
        }

        public void setAverageDuration(long averageDuration) {
            this.averageDuration = averageDuration;
        }

        public long getMinDuration() {
            return this.minDuration;
        }

        public void setMinDuration(long minDuration) {
            this.minDuration = minDuration;
        }

        public long getMaxDuration() {
            return this.maxDuration;
        }

        public void setMaxDuration(long maxDuration) {
            this.maxDuration = maxDuration;
        }
    }
}

