/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.jbpm.JbpmException;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Job;
import org.jbpm.job.Timer;
import org.jbpm.util.CollectionUtil;

public class JobSession {
    private final Session session;
    private static Log log = LogFactory.getLog(JobSession.class);

    public JobSession(Session session) {
        this.session = session;
    }

    public Job getFirstAcquirableJob(String lockOwner) {
        try {
            return (Job)this.session.getNamedQuery("JobSession.getFirstAcquirableJob").setString("lockOwner", lockOwner).setTimestamp("now", new Date()).setMaxResults(1).uniqueResult();
        }
        catch (HibernateException e) {
            throw new JbpmException("could not get first acquirable job", e);
        }
    }

    public List<Job> findExclusiveJobs(String lockOwner, ProcessInstance processInstance) {
        try {
            List jobs = this.session.getNamedQuery("JobSession.findExclusiveJobs").setString("lockOwner", lockOwner).setTimestamp("now", new Date()).setParameter("processInstance", (Object)processInstance).list();
            return CollectionUtil.checkList(jobs, Job.class);
        }
        catch (HibernateException e) {
            throw new JbpmException("could not find exclusive jobs owned by '" + lockOwner + "' for " + processInstance, e);
        }
    }

    public List<Job> findJobsByToken(Token token) {
        try {
            List jobs = this.session.getNamedQuery("JobSession.findJobsByToken").setParameter("token", (Object)token).list();
            return CollectionUtil.checkList(jobs, Job.class);
        }
        catch (HibernateException e) {
            throw new JbpmException("could not find jobs for " + token, e);
        }
    }

    public Job getFirstDueJob(String lockOwner, Collection<Long> monitoredJobs) {
        try {
            Query query;
            if (monitoredJobs == null || monitoredJobs.isEmpty()) {
                query = this.session.getNamedQuery("JobSession.getFirstDueJob");
            } else {
                query = this.session.getNamedQuery("JobSession.getFirstDueJobExcludingMonitoredJobs");
                query.setParameterList("monitoredJobIds", monitoredJobs);
            }
            return (Job)query.setString("lockOwner", lockOwner).setMaxResults(1).uniqueResult();
        }
        catch (HibernateException e) {
            throw new JbpmException("could not get first due job owned by '" + lockOwner + "' ignoring jobs " + monitoredJobs, e);
        }
    }

    public void saveJob(Job job) {
        try {
            this.session.save((Object)job);
        }
        catch (HibernateException e) {
            throw new JbpmException("could not save " + job, e);
        }
    }

    public void deleteJob(Job job) {
        try {
            this.session.delete((Object)job);
            log.debug((Object)("deleted " + job));
        }
        catch (HibernateException e) {
            throw new JbpmException("could not delete " + job, e);
        }
    }

    public Job loadJob(long jobId) {
        try {
            return (Job)this.session.load(Job.class, (Serializable)new Long(jobId));
        }
        catch (HibernateException e) {
            throw new JbpmException("could not load job " + jobId, e);
        }
    }

    public Timer loadTimer(long timerId) {
        try {
            return (Timer)this.session.load(Timer.class, (Serializable)new Long(timerId));
        }
        catch (HibernateException e) {
            throw new JbpmException("could not load timer " + timerId, e);
        }
    }

    public List<Job> loadJobs(long ... jobIds) {
        try {
            List jobs = this.session.createCriteria(Job.class).add(Restrictions.in((String)"id", (Object[])JobSession.toObjectArray(jobIds))).list();
            return CollectionUtil.checkList(jobs, Job.class);
        }
        catch (HibernateException e) {
            throw new JbpmException("could not load jobs " + Arrays.toString(jobIds), e);
        }
    }

    private static Long[] toObjectArray(long[] primitives) {
        int length = primitives.length;
        Long[] objects = new Long[length];
        int i = 0;
        while (i < length) {
            objects[i] = primitives[i];
            ++i;
        }
        return objects;
    }

    public Job getJob(long jobId) {
        try {
            return (Job)this.session.get(Job.class, (Serializable)new Long(jobId));
        }
        catch (HibernateException e) {
            throw new JbpmException("could not get job " + jobId, e);
        }
    }

    public void suspendJobs(Token token) {
        try {
            this.session.getNamedQuery("JobSession.suspendJobs").setParameter("token", (Object)token).executeUpdate();
        }
        catch (HibernateException e) {
            throw new JbpmException("could not suspend jobs for " + token, e);
        }
    }

    public void resumeJobs(Token token) {
        try {
            this.session.getNamedQuery("JobSession.resumeJobs").setParameter("token", (Object)token).executeUpdate();
        }
        catch (HibernateException e) {
            throw new JbpmException("could not resume jobs for " + token, e);
        }
    }

    public void deleteTimersByName(String name, Token token) {
        try {
            int entityCount = this.session.getNamedQuery("JobSession.deleteTimersByName").setString("name", name).setParameter("token", (Object)token).executeUpdate();
            log.debug((Object)("deleted " + entityCount + " timers by name '" + name + "' for " + token));
            List timers = this.session.getNamedQuery("JobSession.findRepeatingTimersByName").setString("name", name).setParameter("token", (Object)token).list();
            JobSession.preventFurtherRepetitions(timers);
        }
        catch (HibernateException e) {
            throw new JbpmException("could not delete timers by name '" + name + "' for " + token, e);
        }
    }

    public int countDeletableJobsForProcessInstance(ProcessInstance processInstance) {
        Number jobCount = (Number)this.session.getNamedQuery("JobSession.countDeletableJobsForProcessInstance").setParameter("processInstance", (Object)processInstance).uniqueResult();
        return jobCount.intValue();
    }

    public void deleteJobsForProcessInstance(ProcessInstance processInstance) {
        try {
            int entityCount = this.session.getNamedQuery("JobSession.deleteJobsForProcessInstance").setParameter("processInstance", (Object)processInstance).executeUpdate();
            log.debug((Object)("deleted " + entityCount + " jobs for " + processInstance));
            List timers = this.session.getNamedQuery("JobSession.findRepeatingTimersForProcessInstance").setParameter("processInstance", (Object)processInstance).list();
            JobSession.preventFurtherRepetitions(timers);
        }
        catch (HibernateException e) {
            throw new JbpmException("could not delete jobs for " + processInstance, e);
        }
    }

    private static void preventFurtherRepetitions(List<?> timers) {
        if (!timers.isEmpty()) {
            for (Timer timer : CollectionUtil.checkList(timers, Timer.class)) {
                timer.setRepeat(null);
            }
            log.debug((Object)("prevented further repetitions of " + timers));
        }
    }

    public List<Job> findJobsWithOverdueLockTime(Date threshold) {
        try {
            List jobs = this.session.getNamedQuery("JobSession.findJobsWithOverdueLockTime").setDate("threshold", threshold).list();
            return CollectionUtil.checkList(jobs, Job.class);
        }
        catch (HibernateException e) {
            throw new JbpmException("could not find jobs with lock time over " + threshold, e);
        }
    }

    public List<Job> findFailedJobs() {
        try {
            List jobs = this.session.getNamedQuery("JobSession.findFailedJobs").list();
            return CollectionUtil.checkList(jobs, Job.class);
        }
        catch (HibernateException e) {
            throw new JbpmException("could not find failed jobs", e);
        }
    }
}

