/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;

public class EventCallback
implements Serializable {
    public static final int DEFAULT_TIMEOUT = 300000;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(EventCallback.class);
    private static final Map<String, Semaphore> eventSemaphores = new HashMap<String, Semaphore>();

    public void processStart() {
        EventCallback.registerNotification("process-start");
    }

    public void processEnd() {
        EventCallback.registerNotification("process-end");
    }

    public void nodeEnter() {
        EventCallback.registerNotification("node-enter");
    }

    public void nodeLeave() {
        EventCallback.registerNotification("node-leave");
    }

    public void taskCreate() {
        EventCallback.registerNotification("task-create");
    }

    public void taskEnd() {
        EventCallback.registerNotification("task-end");
    }

    public void timerCreate() {
        EventCallback.registerNotification("timer-create");
    }

    public void timer() {
        EventCallback.registerNotification("timer");
    }

    public void transition() {
        EventCallback.registerNotification("transition");
    }

    private static void registerNotification(final String event) {
        Synchronization notification = new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                if (status == 3) {
                    log.debug((Object)("sending '" + event + "' notification"));
                    Semaphore eventSemaphore = EventCallback.getEventSemaphore(event);
                    eventSemaphore.release();
                } else {
                    log.warn((Object)("not sending '" + event + "' notification, transaction is " + EventCallback.statusToString(status)));
                }
            }
        };
        JbpmContext.getCurrentJbpmContext().getSession().getTransaction().registerSynchronization(notification);
    }

    private static String statusToString(int status) {
        String text;
        switch (status) {
            case 0: {
                text = "active";
                break;
            }
            case 3: {
                text = "committed";
                break;
            }
            case 8: {
                text = "committing";
                break;
            }
            case 1: {
                text = "marked for rollback";
                break;
            }
            case 6: {
                text = "absent";
                break;
            }
            case 2: {
                text = "prepared";
                break;
            }
            case 7: {
                text = "preparing";
                break;
            }
            case 4: {
                text = "rolled back";
                break;
            }
            case 9: {
                text = "rolling back";
                break;
            }
            default: {
                text = "in unknown status";
            }
        }
        return text;
    }

    public static void waitForEvent(String event) {
        EventCallback.waitForEvent(1, event, 300000L);
    }

    public static void waitForEvent(String event, long timeout) {
        EventCallback.waitForEvent(1, event, timeout);
    }

    public static void waitForEvent(int occurrences, String event) {
        EventCallback.waitForEvent(occurrences, event, 300000L);
    }

    public static void waitForEvent(int occurrences, String event, long timeout) {
        log.debug((Object)("waiting for " + event));
        Semaphore eventSemaphore = EventCallback.getEventSemaphore(event);
        try {
            if (!eventSemaphore.tryAcquire(occurrences, timeout, TimeUnit.MILLISECONDS)) {
                throw new JbpmException("event '" + event + "' did not occur within " + timeout + " ms");
            }
            log.debug((Object)("received '" + event + "' notification"));
        }
        catch (InterruptedException e) {
            throw new JbpmException("wait for event '" + event + "' was interrupted", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Semaphore getEventSemaphore(String event) {
        Map<String, Semaphore> map = eventSemaphores;
        synchronized (map) {
            Semaphore semaphore = eventSemaphores.get(event);
            if (semaphore == null) {
                semaphore = new Semaphore(0);
                eventSemaphores.put(event, semaphore);
            }
            return semaphore;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<String, Semaphore> map = eventSemaphores;
        synchronized (map) {
            for (Map.Entry<String, Semaphore> entry : eventSemaphores.entrySet()) {
                int permits = entry.getValue().drainPermits();
                if (permits == 0) continue;
                log.warn((Object)("event '" + entry.getKey() + "' has " + permits + " outstanding notifications"));
            }
            eventSemaphores.clear();
        }
    }
}

