/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.graph.action.ActionTypes;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.NodeLog;
import org.jbpm.job.ExecuteNodeJob;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;
import org.jbpm.msg.MessageService;
import org.jbpm.svc.Services;
import org.jbpm.util.Clock;

public class Node
extends GraphElement
implements Parsable {
    private static final long serialVersionUID = 1L;
    protected List<Transition> leavingTransitions = null;
    transient Map<String, Transition> leavingTransitionMap = null;
    protected Set<Transition> arrivingTransitions = null;
    protected Action action = null;
    protected SuperState superState = null;
    protected boolean isAsync = false;
    protected boolean isAsyncExclusive = false;
    public static final String[] supportedEventTypes = new String[]{"node-enter", "node-leave", "before-signal", "after-signal"};

    public NodeType getNodeType() {
        return NodeType.Node;
    }

    public String getNameExt() {
        String name = super.getName();
        if (name == null) {
            name = "#anonymous" + (Object)((Object)this.getNodeType());
        }
        return name;
    }

    @Override
    public String[] getSupportedEventTypes() {
        return supportedEventTypes;
    }

    public Node() {
    }

    public Node(String name) {
        super(name);
    }

    @Override
    public void read(Element nodeElement, JpdlXmlReader jpdlXmlReader) {
        this.action = jpdlXmlReader.readSingleAction(nodeElement);
    }

    @Override
    public void write(Element nodeElement) {
        if (this.action != null) {
            String actionName = ActionTypes.getActionName(this.action.getClass());
            Element actionElement = nodeElement.addElement(actionName);
            this.action.write(actionElement);
        }
    }

    public List<Transition> getLeavingTransitions() {
        return this.leavingTransitions;
    }

    public List<Transition> getLeavingTransitionsList() {
        return this.leavingTransitions;
    }

    public Map<String, Transition> getLeavingTransitionsMap() {
        if (this.leavingTransitionMap == null && this.leavingTransitions != null) {
            this.leavingTransitionMap = new HashMap<String, Transition>();
            ListIterator<Transition> iter = this.leavingTransitions.listIterator(this.leavingTransitions.size());
            while (iter.hasPrevious()) {
                Transition leavingTransition = iter.previous();
                this.leavingTransitionMap.put(leavingTransition.getName(), leavingTransition);
            }
        }
        return this.leavingTransitionMap;
    }

    public Transition addLeavingTransition(Transition leavingTransition) {
        if (leavingTransition == null) {
            throw new IllegalArgumentException("can't add a null leaving transition to an node");
        }
        if (this.leavingTransitions == null) {
            this.leavingTransitions = new ArrayList<Transition>();
        }
        this.leavingTransitions.add(leavingTransition);
        leavingTransition.from = this;
        this.leavingTransitionMap = null;
        return leavingTransition;
    }

    public void removeLeavingTransition(Transition leavingTransition) {
        if (leavingTransition == null) {
            throw new IllegalArgumentException("can't remove a null leavingTransition from an node");
        }
        if (this.leavingTransitions != null && this.leavingTransitions.remove(leavingTransition)) {
            leavingTransition.from = null;
            this.leavingTransitionMap = null;
        }
    }

    public boolean hasLeavingTransition(String transitionName) {
        if (this.leavingTransitions == null) {
            return false;
        }
        return this.getLeavingTransitionsMap().containsKey(transitionName);
    }

    public Transition getLeavingTransition(String transitionName) {
        Transition transition = null;
        if (this.leavingTransitions != null) {
            transition = this.getLeavingTransitionsMap().get(transitionName);
        }
        if (transition == null && this.superState != null) {
            transition = this.superState.getLeavingTransition(transitionName);
        }
        return transition;
    }

    public boolean hasNoLeavingTransitions() {
        return !(this.leavingTransitions != null && this.leavingTransitions.size() != 0 || this.superState != null && !this.superState.hasNoLeavingTransitions());
    }

    public String generateNextLeavingTransitionName() {
        String name = null;
        if (this.leavingTransitions != null && this.containsName(this.leavingTransitions, null)) {
            int n = 1;
            while (this.containsName(this.leavingTransitions, Integer.toString(n))) {
                ++n;
            }
            name = Integer.toString(n);
        }
        return name;
    }

    boolean containsName(List<Transition> leavingTransitions, String name) {
        if (name != null) {
            for (Transition transition : leavingTransitions) {
                if (!name.equals(transition.getName())) continue;
                return true;
            }
        } else {
            for (Transition transition : leavingTransitions) {
                if (transition.getName() != null) continue;
                return true;
            }
        }
        return false;
    }

    public Transition getDefaultLeavingTransition() {
        Transition defaultTransition = null;
        if (this.leavingTransitions != null) {
            for (Transition auxTransition : this.leavingTransitions) {
                if (auxTransition.getCondition() != null) continue;
                defaultTransition = auxTransition;
                break;
            }
        } else if (this.superState != null) {
            defaultTransition = this.superState.getDefaultLeavingTransition();
        }
        return defaultTransition;
    }

    public void reorderLeavingTransition(int oldIndex, int newIndex) {
        if (this.leavingTransitions != null && Math.min(oldIndex, newIndex) >= 0 && Math.max(oldIndex, newIndex) < this.leavingTransitions.size()) {
            Transition o = this.leavingTransitions.remove(oldIndex);
            this.leavingTransitions.add(newIndex, o);
        }
    }

    public Set<Transition> getArrivingTransitions() {
        return this.arrivingTransitions;
    }

    public Transition addArrivingTransition(Transition arrivingTransition) {
        if (arrivingTransition == null) {
            throw new IllegalArgumentException("can't add a null arrivingTransition to a node");
        }
        if (this.arrivingTransitions == null) {
            this.arrivingTransitions = new HashSet<Transition>();
        }
        this.arrivingTransitions.add(arrivingTransition);
        arrivingTransition.to = this;
        return arrivingTransition;
    }

    public void removeArrivingTransition(Transition arrivingTransition) {
        if (arrivingTransition == null) {
            throw new IllegalArgumentException("can't remove a null arrivingTransition from a node");
        }
        if (this.arrivingTransitions != null && this.arrivingTransitions.remove(arrivingTransition)) {
            arrivingTransition.to = null;
        }
    }

    @Override
    public GraphElement getParent() {
        GraphElement parent = this.processDefinition;
        if (this.superState != null) {
            parent = this.superState;
        }
        return parent;
    }

    public void enter(ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        token.setNode(this);
        this.fireEvent("node-enter", executionContext);
        token.setNodeEnter(Clock.getCurrentTime());
        executionContext.setTransition(null);
        executionContext.setTransitionSource(null);
        if (this.isAsync) {
            ExecuteNodeJob job = this.createAsyncContinuationJob(token);
            MessageService messageService = (MessageService)Services.getCurrentService("message");
            messageService.send(job);
            token.lock(job.toString());
        } else {
            this.execute(executionContext);
        }
    }

    protected ExecuteNodeJob createAsyncContinuationJob(Token token) {
        ExecuteNodeJob job = new ExecuteNodeJob(token);
        job.setNode(this);
        job.setDueDate(new Date());
        job.setExclusive(this.isAsyncExclusive);
        return job;
    }

    public void execute(ExecutionContext executionContext) {
        if (this.action != null) {
            try {
                this.executeAction(this.action, executionContext);
            }
            catch (Exception exception) {
                this.raiseException(exception, executionContext);
            }
        } else {
            this.leave(executionContext);
        }
    }

    public void leave(ExecutionContext executionContext) {
        this.leave(executionContext, this.getDefaultLeavingTransition());
    }

    public void leave(ExecutionContext executionContext, String transitionName) {
        Transition transition = this.getLeavingTransition(transitionName);
        if (transition == null) {
            throw new JbpmException("transition '" + transitionName + "' is not a leaving transition of node '" + this + "'");
        }
        this.leave(executionContext, transition);
    }

    public void leave(ExecutionContext executionContext, Transition transition) {
        if (transition == null) {
            throw new JbpmException("can't leave node '" + this + "' without leaving transition");
        }
        Token token = executionContext.getToken();
        token.setNode(this);
        executionContext.setTransition(transition);
        this.fireEvent("node-leave", executionContext);
        if (token.getNodeEnter() != null) {
            this.addNodeLog(token);
        }
        executionContext.setTransitionSource(this);
        transition.take(executionContext);
    }

    protected void addNodeLog(Token token) {
        token.addLog(new NodeLog(this, token.getNodeEnter(), Clock.getCurrentTime()));
    }

    @Override
    public ProcessDefinition getProcessDefinition() {
        ProcessDefinition pd = this.processDefinition;
        if (this.superState != null) {
            pd = this.superState.getProcessDefinition();
        }
        return pd;
    }

    @Override
    public void setName(String name) {
        if (name != null && name.contains("/")) {
            throw new IllegalArgumentException("Invalid node name: " + name);
        }
        if (this.isDifferent(this.name, name)) {
            String oldName = this.name;
            if (this.superState != null) {
                if (this.superState.hasNode(name)) {
                    throw new IllegalArgumentException("couldn't set name '" + name + "' on node '" + this + "'cause the superState of this node has already another child node with the same name");
                }
                Map<String, Node> nodes = this.superState.getNodesMap();
                nodes.remove(oldName);
                nodes.put(name, this);
            } else if (this.processDefinition != null) {
                if (this.processDefinition.hasNode(name)) {
                    throw new IllegalArgumentException("couldn't set name '" + name + "' on node '" + this + "'cause the process definition of this node has already another node with the same name");
                }
                Map<String, Node> nodeMap = this.processDefinition.getNodesMap();
                nodeMap.remove(oldName);
                nodeMap.put(name, this);
            }
            this.name = name;
        }
    }

    boolean isDifferent(String name1, String name2) {
        if (name1 != null && name1.equals(name2)) {
            return false;
        }
        return name1 != null || name2 != null;
    }

    public String getFullyQualifiedName() {
        String fullyQualifiedName = this.name;
        if (this.superState != null) {
            fullyQualifiedName = String.valueOf(this.superState.getFullyQualifiedName()) + "/" + this.name;
        }
        return fullyQualifiedName;
    }

    public boolean isSuperStateNode() {
        return false;
    }

    public List<Node> getNodes() {
        return null;
    }

    public SuperState getSuperState() {
        return this.superState;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    public boolean isAsyncExclusive() {
        return this.isAsyncExclusive;
    }

    public void setAsyncExclusive(boolean isAsyncExclusive) {
        this.isAsyncExclusive = isAsyncExclusive;
    }

    public static enum NodeType {
        Node,
        StartState,
        EndState,
        State,
        Task,
        Fork,
        Join,
        Decision;

    }
}

