/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.node.DecisionCondition;
import org.jbpm.graph.node.DecisionHandler;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class Decision
extends Node {
    static final long serialVersionUID = 1L;
    List<DecisionCondition> decisionConditions = null;
    Delegation decisionDelegation = null;
    String decisionExpression = null;
    private static Log log = LogFactory.getLog(Decision.class);

    public Decision() {
    }

    public Decision(String name) {
        super(name);
    }

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.Decision;
    }

    @Override
    public void read(Element decisionElement, JpdlXmlReader jpdlReader) {
        String expression = decisionElement.attributeValue("expression");
        Element decisionHandlerElement = decisionElement.element("handler");
        if (expression != null) {
            this.decisionExpression = expression;
        } else if (decisionHandlerElement != null) {
            this.decisionDelegation = new Delegation();
            this.decisionDelegation.read(decisionHandlerElement, jpdlReader);
        }
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        Transition transition;
        block18: {
            ClassLoader contextClassLoader;
            Thread currentThread;
            block17: {
                transition = null;
                currentThread = Thread.currentThread();
                contextClassLoader = currentThread.getContextClassLoader();
                currentThread.setContextClassLoader(JbpmConfiguration.getProcessClassLoader(executionContext.getProcessDefinition()));
                try {
                    try {
                        if (this.decisionDelegation != null) {
                            String transitionName;
                            DecisionHandler decisionHandler = (DecisionHandler)this.decisionDelegation.getInstance();
                            if (decisionHandler == null) {
                                decisionHandler = (DecisionHandler)this.decisionDelegation.instantiate();
                            }
                            if ((transition = this.getLeavingTransition(transitionName = decisionHandler.decide(executionContext))) == null) {
                                throw new JbpmException("decision '" + this.name + "' selected non existing transition '" + transitionName + "'");
                            }
                            break block17;
                        }
                        if (this.decisionExpression != null) {
                            Object result = JbpmExpressionEvaluator.evaluate(this.decisionExpression, executionContext);
                            if (result == null) {
                                throw new JbpmException("decision expression '" + this.decisionExpression + "' returned null");
                            }
                            String transitionName = result.toString();
                            transition = this.getLeavingTransition(transitionName);
                            if (transition == null) {
                                throw new JbpmException("decision '" + this.name + "' selected non existing transition '" + transitionName + "'");
                            }
                            break block17;
                        }
                        if (this.decisionConditions != null && !this.decisionConditions.isEmpty()) {
                            for (DecisionCondition decisionCondition : this.decisionConditions) {
                                String transitionName;
                                Object result = JbpmExpressionEvaluator.evaluate(decisionCondition.getExpression(), executionContext);
                                if (!Boolean.TRUE.equals(result) || (transition = this.getLeavingTransition(transitionName = decisionCondition.getTransitionName())) == null) {
                                    continue;
                                }
                                break block17;
                            }
                            break block17;
                        }
                        for (Transition candidate : this.leavingTransitions) {
                            Object result;
                            String conditionExpression = candidate.getCondition();
                            if (conditionExpression == null || !Boolean.TRUE.equals(result = JbpmExpressionEvaluator.evaluate(conditionExpression, executionContext))) continue;
                            transition = candidate;
                            break;
                        }
                    }
                    catch (Exception exception) {
                        this.raiseException(exception, executionContext);
                        if (!this.equals(executionContext.getNode())) {
                            currentThread.setContextClassLoader(contextClassLoader);
                            return;
                        }
                        currentThread.setContextClassLoader(contextClassLoader);
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    currentThread.setContextClassLoader(contextClassLoader);
                    throw throwable;
                }
            }
            currentThread.setContextClassLoader(contextClassLoader);
        }
        if (transition == null) {
            transition = this.getDefaultLeavingTransition();
            if (transition == null) {
                throw new JbpmException("decision cannot select transition: " + this);
            }
            log.debug((Object)("decision did not select transition, taking default " + transition));
        }
        transition.removeConditionEnforcement();
        log.debug((Object)("decision '" + this.name + "' is taking " + transition));
        executionContext.leaveNode(transition);
    }

    public List<DecisionCondition> getDecisionConditions() {
        return this.decisionConditions;
    }

    public void setDecisionDelegation(Delegation decisionDelegation) {
        this.decisionDelegation = decisionDelegation;
    }
}

