/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.graph.action.Script;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class Fork
extends Node {
    private static final long serialVersionUID = 1L;
    Script script = null;
    private static Log log = LogFactory.getLog(Fork.class);

    public Fork() {
    }

    public Fork(String name) {
        super(name);
    }

    @Override
    public Node.NodeType getNodeType() {
        return Node.NodeType.Fork;
    }

    @Override
    public void read(Element forkElement, JpdlXmlReader jpdlReader) {
        Element scriptElement = forkElement.element("script");
        if (scriptElement != null) {
            log.warn((Object)"KNOWN LIMITATION: the script in a fork is not persisted.  script in fork might be removed in later versions of jPDL");
            this.script = new Script();
            this.script.read(scriptElement, jpdlReader);
        }
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        Collection transitionNames = null;
        if (this.script == null) {
            transitionNames = this.getLeavingTransitionsMap().keySet();
        } else {
            Object object;
            Map<String, Object> outputMap = this.script.eval(token);
            if (outputMap.size() == 1 && (object = outputMap.values().iterator().next()) instanceof Collection) {
                transitionNames = (Collection)object;
            }
            if (transitionNames == null) {
                throw new JbpmException("script for fork '" + this.name + "' should produce one collection (in one writable variable): " + transitionNames);
            }
        }
        HashMap<String, Token> forkedTokens = new HashMap<String, Token>();
        for (Object e : transitionNames) {
            String transitionName = (String)e;
            Token childToken = this.createForkedToken(token, transitionName);
            forkedTokens.put(transitionName, childToken);
        }
        for (Map.Entry entry : forkedTokens.entrySet()) {
            Token childToken = (Token)entry.getValue();
            String leavingTransitionName = (String)entry.getKey();
            ExecutionContext childExecutionContext = new ExecutionContext(childToken);
            if (leavingTransitionName != null) {
                this.leave(childExecutionContext, leavingTransitionName);
                continue;
            }
            this.leave(childExecutionContext);
        }
    }

    protected Token createForkedToken(Token parent, String transitionName) {
        return new Token(parent, this.getTokenName(parent, transitionName));
    }

    protected String getTokenName(Token parent, String transitionName) {
        String tokenName = null;
        if (transitionName != null) {
            if (!parent.hasChild(transitionName)) {
                tokenName = transitionName;
            } else {
                int i = 2;
                tokenName = String.valueOf(transitionName) + Integer.toString(i);
                while (parent.hasChild(tokenName)) {
                    tokenName = String.valueOf(transitionName) + Integer.toString(++i);
                }
            }
        } else {
            int size = parent.getChildren() != null ? parent.getChildren().size() + 1 : 1;
            tokenName = Integer.toString(size);
        }
        return tokenName;
    }

    public Script getScript() {
        return this.script;
    }

    public void setScript(Script script) {
        this.script = script;
    }
}

