/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.ArrayList;
import java.util.Collection;
import org.dom4j.Element;
import org.jbpm.JbpmException;
import org.jbpm.context.def.ContextDefinition;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.util.CollectionUtil;

public class InterleaveStart
extends Node {
    private static final long serialVersionUID = 1L;
    String variableName = "interleave-transition-names";
    Interleaver interleaver = new DefaultInterleaver();

    public InterleaveStart() {
    }

    public InterleaveStart(String name) {
        super(name);
    }

    @Override
    public void read(Element element, JpdlXmlReader jpdlReader) {
        ProcessDefinition processDefinition = jpdlReader.getProcessDefinition();
        if (processDefinition.getDefinition(ContextDefinition.class) == null) {
            processDefinition.addDefinition(new ContextDefinition());
        }
    }

    @Override
    public void write(Element element) {
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        Token token = executionContext.getToken();
        Collection<String> transitionNames = this.retrieveTransitionNames(token);
        if (transitionNames == null) {
            transitionNames = new ArrayList<String>(this.getTransitionNames(token));
        }
        String nextTransition = this.interleaver.selectNextTransition(transitionNames);
        transitionNames.remove(nextTransition);
        this.storeTransitionNames(transitionNames, token);
        token.getNode().leave(executionContext, nextTransition);
    }

    protected Collection<String> getTransitionNames(Token token) {
        Node node = token.getNode();
        return node.getLeavingTransitionsMap().keySet();
    }

    protected void storeTransitionNames(Collection<String> transitionNames, Token token) {
        ContextInstance ci = token.getProcessInstance().getContextInstance();
        if (ci == null) {
            throw new JbpmException("an interleave start node requires the availability of a context");
        }
        ci.setVariable(this.variableName, transitionNames, token);
    }

    public Collection<String> retrieveTransitionNames(Token token) {
        ContextInstance ci = token.getProcessInstance().getContextInstance();
        Collection collection = (Collection)ci.getVariable(this.variableName, token);
        return collection != null ? CollectionUtil.checkCollection(collection, String.class) : null;
    }

    public void removeTransitionNames(Token token) {
        ContextInstance ci = token.getProcessInstance().getContextInstance();
        ci.setVariable(this.variableName, null, token);
    }

    public Interleaver getInterleaver() {
        return this.interleaver;
    }

    public void setInterleaver(Interleaver interleaver) {
        this.interleaver = interleaver;
    }

    public class DefaultInterleaver
    implements Interleaver {
        @Override
        public String selectNextTransition(Collection<String> transitionNames) {
            return transitionNames.iterator().next();
        }
    }

    public static interface Interleaver {
        public String selectNextTransition(Collection<String> var1);
    }
}

