/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.dom4j.tree.FlyweightAttribute;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.ProcessStateLog;
import org.jbpm.graph.node.DbSubProcessResolver;
import org.jbpm.graph.node.SubProcessResolver;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.util.Clock;

public class ProcessState
extends Node {
    private static final long serialVersionUID = 1L;
    static SubProcessResolver defaultSubProcessResolver = new DbSubProcessResolver();
    protected ProcessDefinition subProcessDefinition = null;
    protected Set<VariableAccess> variableAccesses = null;
    protected String subProcessName = null;
    public static final String[] supportedEventTypes = new String[]{"subprocess-created", "subprocess-end", "node-enter", "node-leave", "before-signal", "after-signal"};
    private static Log log = LogFactory.getLog(ProcessState.class);

    public static void setDefaultSubProcessResolver(SubProcessResolver subProcessResolver) {
        defaultSubProcessResolver = subProcessResolver;
    }

    @Override
    public String[] getSupportedEventTypes() {
        return supportedEventTypes;
    }

    public Set<VariableAccess> getVariableAccesses() {
        return this.variableAccesses;
    }

    public void setVariableAccesses(Set<VariableAccess> variableAccesses) {
        this.variableAccesses = variableAccesses;
    }

    @Override
    public void read(Element processStateElement, JpdlXmlReader jpdlReader) {
        Element subProcessElement = processStateElement.element("sub-process");
        if (subProcessElement != null) {
            String binding = subProcessElement.attributeValue("binding");
            if ("late".equalsIgnoreCase(binding)) {
                this.subProcessName = subProcessElement.attributeValue("name");
            } else {
                String subProcessName;
                SubProcessResolver subProcessResolver = this.getSubProcessResolver();
                try {
                    this.subProcessDefinition = subProcessResolver.findSubProcess(subProcessElement);
                }
                catch (JbpmException e) {
                    jpdlReader.addWarning(e.getMessage());
                }
                if (this.subProcessDefinition == null && (subProcessName = subProcessElement.attributeValue("name")).equals(this.processDefinition.getName())) {
                    this.subProcessDefinition = this.processDefinition;
                }
            }
        }
        if (this.subProcessDefinition != null) {
            log.debug((Object)("subprocess for process-state '" + this.name + "' bound to " + this.subProcessDefinition));
        } else if (this.subProcessName != null) {
            log.debug((Object)("subprocess for process-state '" + this.name + "' will be late bound to " + this.subProcessName));
        } else {
            log.debug((Object)("subprocess for process-state '" + this.name + "' not yet bound"));
        }
        this.variableAccesses = new HashSet<VariableAccess>(jpdlReader.readVariableAccesses(processStateElement));
    }

    private SubProcessResolver getSubProcessResolver() {
        SubProcessResolver subProcessResolver = defaultSubProcessResolver;
        if (JbpmConfiguration.Configs.hasObject("jbpm.sub.process.resolver")) {
            subProcessResolver = (SubProcessResolver)JbpmConfiguration.Configs.getObject("jbpm.sub.process.resolver");
        }
        return subProcessResolver;
    }

    @Override
    public void execute(ExecutionContext executionContext) {
        Token superProcessToken = executionContext.getToken();
        ProcessDefinition usedSubProcessDefinition = this.subProcessDefinition;
        if (this.subProcessDefinition == null && this.subProcessName != null) {
            SubProcessResolver subProcessResolver = this.getSubProcessResolver();
            ArrayList<FlyweightAttribute> attributes = new ArrayList<FlyweightAttribute>();
            String subProcessNameResolved = (String)JbpmExpressionEvaluator.evaluate(this.subProcessName, executionContext);
            if (log.isDebugEnabled()) {
                log.debug((Object)("SubProcessName after eval: " + subProcessNameResolved));
            }
            attributes.add(new FlyweightAttribute("name", subProcessNameResolved));
            DefaultElement subProcessElement = new DefaultElement("sub-process");
            subProcessElement.setAttributes(attributes);
            usedSubProcessDefinition = subProcessResolver.findSubProcess((Element)subProcessElement);
        }
        ProcessInstance subProcessInstance = superProcessToken.createSubProcessInstance(usedSubProcessDefinition);
        this.fireEvent("subprocess-created", executionContext);
        if (this.variableAccesses != null && !this.variableAccesses.isEmpty()) {
            ContextInstance superContextInstance = executionContext.getContextInstance();
            ContextInstance subContextInstance = subProcessInstance.getContextInstance();
            subContextInstance.setTransientVariables(superContextInstance.getTransientVariables());
            for (VariableAccess variableAccess : this.variableAccesses) {
                if (!variableAccess.isReadable()) continue;
                String variableName = variableAccess.getVariableName();
                Object value = superContextInstance.getVariable(variableName, superProcessToken);
                String mappedName = variableAccess.getMappedName();
                log.debug((Object)("copying super process var '" + variableName + "' to sub process var '" + mappedName + "': " + value));
                if (value == null) continue;
                subContextInstance.setVariable(mappedName, value);
            }
        }
        subProcessInstance.signal();
    }

    @Override
    public void leave(ExecutionContext executionContext, Transition transition) {
        ProcessInstance subProcessInstance = executionContext.getSubProcessInstance();
        Token superProcessToken = subProcessInstance.getSuperProcessToken();
        if (this.variableAccesses != null && !this.variableAccesses.isEmpty()) {
            ContextInstance superContextInstance = executionContext.getContextInstance();
            ContextInstance subContextInstance = subProcessInstance.getContextInstance();
            for (VariableAccess variableAccess : this.variableAccesses) {
                if (!variableAccess.isWritable()) continue;
                String mappedName = variableAccess.getMappedName();
                Object value = subContextInstance.getVariable(mappedName);
                String variableName = variableAccess.getVariableName();
                log.debug((Object)("copying sub process var '" + mappedName + "' to super process var '" + variableName + "': " + value));
                if (value == null) continue;
                superContextInstance.setVariable(variableName, value, superProcessToken);
            }
        }
        this.fireEvent("subprocess-end", executionContext);
        superProcessToken.setSubProcessInstance(null);
        superProcessToken.addLog(new ProcessStateLog(this, superProcessToken.getNodeEnter(), Clock.getCurrentTime(), subProcessInstance));
        super.leave(executionContext, this.getDefaultLeavingTransition());
    }

    @Override
    protected void addNodeLog(Token token) {
    }

    public ProcessDefinition getSubProcessDefinition() {
        return this.subProcessDefinition;
    }

    public void setSubProcessDefinition(ProcessDefinition subProcessDefinition) {
        this.subProcessDefinition = subProcessDefinition;
    }
}

