/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.instantiation.FieldInstantiator;

public class BeanInstantiator
extends FieldInstantiator {
    private static final Log log = LogFactory.getLog(BeanInstantiator.class);

    @Override
    protected void setPropertyValue(Object instance, String propertyName, Element propertyElement) {
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Method method = this.findSetter(instance.getClass(), setterName);
        if (method != null) {
            method.setAccessible(true);
            Class<?> propertyType = method.getParameterTypes()[0];
            Object value = BeanInstantiator.getValue(propertyType, propertyElement);
            try {
                method.invoke(instance, value);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("property '" + propertyName + "' is inaccesible"), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("property '" + propertyName + "' cannot be set to value " + value), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)("write method for property '" + propertyName + "' threw exception"), e.getCause());
            }
        } else {
            log.error((Object)("property '" + propertyName + "' does not exist or is not writeable"));
        }
    }

    private Method findSetter(Class<?> clazz, String setterName) {
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (setterName.equals(method.getName()) && method.getParameterTypes().length == 1) {
                return method;
            }
            ++n2;
        }
        Class<?> superclass = clazz.getSuperclass();
        return superclass != null ? this.findSetter(superclass, setterName) : null;
    }
}

