/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.instantiation.Instantiator;
import org.jbpm.instantiation.InstantiatorUtil;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.CollectionUtil;

public class FieldInstantiator
implements Instantiator {
    private static final Log log = LogFactory.getLog(FieldInstantiator.class);

    @Override
    public <T> T instantiate(Class<T> type, String configuration) {
        T instance = InstantiatorUtil.instantiate(type);
        if (configuration != null && configuration.length() > 0) {
            Element configurationElement = InstantiatorUtil.parseConfiguration(configuration);
            for (Object i : configurationElement.elements()) {
                Element propertyElement = (Element)i;
                String propertyName = propertyElement.getName();
                this.setPropertyValue(instance, propertyName, propertyElement);
            }
        }
        return instance;
    }

    protected void setPropertyValue(Object instance, String propertyName, Element propertyElement) {
        Field field = this.findField(instance.getClass(), propertyName);
        if (field != null) {
            field.setAccessible(true);
            Object value = FieldInstantiator.getValue(field.getType(), propertyElement);
            try {
                field.set(instance, value);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("field '" + propertyName + "' cannot be set to value " + value), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)(" field '" + propertyName + "' is inaccessible"), (Throwable)e);
            }
        }
    }

    private Field findField(Class<?> clazz, String propertyName) {
        try {
            return clazz.getDeclaredField(propertyName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superclass = clazz.getSuperclass();
            return superclass != null ? this.findField(superclass, propertyName) : null;
        }
    }

    public static Object getValue(Class<?> type, Element propertyElement) {
        Object value;
        block42: {
            value = null;
            if (type == String.class) {
                value = propertyElement.getText();
            } else if (type == Integer.class || type == Integer.TYPE) {
                value = new Integer(propertyElement.getTextTrim());
            } else if (type == Long.class || type == Long.TYPE) {
                value = new Long(propertyElement.getTextTrim());
            } else if (type == Float.class || type == Float.TYPE) {
                value = new Float(propertyElement.getTextTrim());
            } else if (type == Double.class || type == Double.TYPE) {
                value = new Double(propertyElement.getTextTrim());
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                value = Boolean.valueOf(propertyElement.getTextTrim());
            } else if (type == Character.class || type == Character.TYPE) {
                value = new Character(propertyElement.getTextTrim().charAt(0));
            } else if (type == Short.class || type == Short.TYPE) {
                value = new Short(propertyElement.getTextTrim());
            } else if (type == Byte.class || type == Byte.TYPE) {
                value = new Byte(propertyElement.getTextTrim());
            } else if (type == List.class || type == Collection.class) {
                value = FieldInstantiator.getCollection(propertyElement, new ArrayList<Object>());
            } else if (type == Queue.class) {
                value = FieldInstantiator.getCollection(propertyElement, new LinkedList<Object>());
            } else if (type == Set.class) {
                value = FieldInstantiator.getCollection(propertyElement, new HashSet<Object>());
            } else if (type == SortedSet.class) {
                value = FieldInstantiator.getCollection(propertyElement, new TreeSet<Object>());
            } else if (type == Map.class) {
                value = FieldInstantiator.getMap(propertyElement, new HashMap<Object, Object>());
            } else if (type == SortedMap.class) {
                value = FieldInstantiator.getMap(propertyElement, new TreeMap<Object, Object>());
            } else if (Element.class.isAssignableFrom(type)) {
                value = propertyElement;
            } else {
                try {
                    if (Collection.class.isAssignableFrom(type)) {
                        value = FieldInstantiator.getCollection(propertyElement, CollectionUtil.checkCollection((Collection)type.newInstance(), Object.class));
                        break block42;
                    }
                    if (Map.class.isAssignableFrom(type)) {
                        value = FieldInstantiator.getMap(propertyElement, CollectionUtil.checkMap((Map)type.newInstance(), Object.class, Object.class));
                        break block42;
                    }
                    try {
                        Constructor<?> constructor = type.getConstructor(String.class);
                        if (propertyElement.isTextOnly()) {
                            value = constructor.newInstance(propertyElement.getTextTrim());
                            break block42;
                        }
                        log.error((Object)("element '" + propertyElement.getName() + "' has non-text content"));
                    }
                    catch (NoSuchMethodException e) {
                        log.error((Object)(type + " does not have a string constructor"), (Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        log.error((Object)(type + " cannot be constructed with value " + propertyElement.getTextTrim()), (Throwable)e);
                    }
                }
                catch (InstantiationException e) {
                    log.error((Object)("could not instantiate " + type), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)(type + " is inaccessible"), (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    log.error((Object)("constructor for " + type + " threw exception"), e.getCause());
                }
            }
        }
        return value;
    }

    private static Map<Object, Object> getMap(Element mapElement, Map<Object, Object> map) {
        Class<?> keyClass = FieldInstantiator.classForAttributeValue(mapElement, "key-type");
        Class<?> valueClass = FieldInstantiator.classForAttributeValue(mapElement, "value-type");
        for (Object o : mapElement.elements()) {
            Element element = (Element)o;
            Element keyElement = element.element("key");
            Element valueElement = element.element("value");
            map.put(FieldInstantiator.getValue(keyClass, keyElement), FieldInstantiator.getValue(valueClass, valueElement));
        }
        return map;
    }

    private static Collection<Object> getCollection(Element collectionElement, Collection<Object> collection) {
        Class<?> elementClass = FieldInstantiator.classForAttributeValue(collectionElement, "element-type");
        for (Object element : collectionElement.elements()) {
            collection.add(FieldInstantiator.getValue(elementClass, (Element)element));
        }
        return collection;
    }

    private static Class<?> classForAttributeValue(Element element, String attributeName) {
        Class type = String.class;
        String attributeValue = element.attributeValue(attributeName);
        if (attributeValue != null) {
            type = ClassLoaderUtil.classForName(attributeValue);
        }
        return type;
    }
}

