/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.instantiation;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jbpm.JbpmException;

class InstantiatorUtil {
    private InstantiatorUtil() {
    }

    public static <T> T instantiate(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (InstantiationException e) {
            throw new JbpmException("could not instantiate " + type, e);
        }
        catch (IllegalAccessException e) {
            throw new JbpmException(type + " is inaccessible", e);
        }
    }

    public static <T, C> T instantiate(Class<T> type, Class<C> configType, C config) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(configType);
            constructor.setAccessible(true);
            return constructor.newInstance(config);
        }
        catch (NoSuchMethodException e) {
            throw new JbpmException(type + " does not have a " + config.getClass().getSimpleName() + " constructor", e);
        }
        catch (InstantiationException e) {
            throw new JbpmException("could not instantiate " + type, e);
        }
        catch (IllegalAccessException e) {
            throw new JbpmException(type + " is inaccessible", e);
        }
        catch (IllegalArgumentException e) {
            throw new JbpmException(type + " cannot be constructed with value " + config, e);
        }
        catch (InvocationTargetException e) {
            throw new JbpmException("constructor for " + type + " threw exception", e.getCause());
        }
    }

    public static Element parseConfiguration(String config) {
        Element element = null;
        try {
            element = DocumentHelper.parseText((String)("<action>" + config + "</action>")).getRootElement();
        }
        catch (DocumentException e) {
            throw new JbpmException("failed to parse configuration: " + config, e);
        }
        return element;
    }
}

