/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.job.executor.JobExecutorThread;
import org.jbpm.job.executor.LockMonitorThread;

public class JobExecutor
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected JbpmConfiguration jbpmConfiguration;
    protected String name;
    protected int nbrOfThreads;
    protected int idleInterval;
    protected int maxIdleInterval;
    @Deprecated
    protected int historyMaxSize;
    protected int maxLockTime;
    protected int lockMonitorInterval;
    protected int lockBufferTime;
    protected Map<String, Thread> threads = new HashMap<String, Thread>();
    protected LockMonitorThread lockMonitorThread;
    protected Map<String, Long> monitoredJobIds = new Hashtable<String, Long>();
    protected boolean isStarted = false;
    private static String hostName;
    private static Log log;

    static {
        log = LogFactory.getLog(JobExecutor.class);
    }

    public synchronized void start() {
        if (!this.isStarted) {
            log.debug((Object)("starting job executor '" + this.name + "'..."));
            int i = 0;
            while (i < this.nbrOfThreads) {
                this.startThread();
                ++i;
            }
            this.lockMonitorThread = new LockMonitorThread(this);
            this.isStarted = true;
        } else {
            log.debug((Object)("ignoring start: job executor '" + this.name + "' is already started'"));
        }
    }

    public synchronized List<Thread> stop() {
        List<Thread> stoppedThreads;
        if (this.isStarted) {
            log.debug((Object)("stopping job executor '" + this.name + "'..."));
            this.isStarted = false;
            stoppedThreads = new ArrayList<Thread>(this.threads.size());
            int i = 0;
            while (i < this.nbrOfThreads) {
                stoppedThreads.add(this.stopThread());
                ++i;
            }
            if (this.lockMonitorThread != null) {
                this.lockMonitorThread.deactivate();
            }
        } else {
            log.debug((Object)("ignoring stop: job executor '" + this.name + "' not started"));
            stoppedThreads = Collections.emptyList();
        }
        return stoppedThreads;
    }

    public void stopAndJoin() throws InterruptedException {
        for (Thread thread : this.stop()) {
            thread.join();
        }
        if (this.lockMonitorThread != null) {
            this.lockMonitorThread.join();
        }
    }

    protected synchronized void startThread() {
        String threadName = this.getNextThreadName();
        Thread thread = this.createThread(threadName);
        this.threads.put(threadName, thread);
        log.debug((Object)("starting new job executor thread '" + threadName + "'"));
        thread.start();
    }

    protected Thread createThread(String threadName) {
        return new JobExecutorThread(threadName, this);
    }

    protected String getNextThreadName() {
        return this.getThreadName(this.threads.size() + 1);
    }

    protected String getLastThreadName() {
        return this.getThreadName(this.threads.size());
    }

    private String getThreadName(int index) {
        return String.valueOf(this.name) + '@' + JobExecutor.getHostAddress() + ':' + index;
    }

    private static String getHostAddress() {
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                hostName = "127.0.0.1";
            }
        }
        return hostName;
    }

    protected synchronized Thread stopThread() {
        String threadName = this.getLastThreadName();
        log.debug((Object)("removing job executor thread '" + threadName + "'"));
        Thread thread = this.threads.remove(threadName);
        if (thread instanceof JobExecutorThread) {
            JobExecutorThread jobThread = (JobExecutorThread)thread;
            jobThread.deactivate();
        }
        return thread;
    }

    public Set<Long> getMonitoredJobIds() {
        return new HashSet<Long>(this.monitoredJobIds.values());
    }

    public void addMonitoredJobId(String threadName, long jobId) {
        this.monitoredJobIds.put(threadName, new Long(jobId));
    }

    public void removeMonitoredJobId(String threadName) {
        this.monitoredJobIds.remove(threadName);
    }

    @Deprecated
    public void setMonitoredJobIds(Map<String, Long> monitoredJobIds) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int getHistoryMaxSize() {
        return this.historyMaxSize;
    }

    @Deprecated
    public void setHistoryMaxSize(int historyMaxSize) {
        this.historyMaxSize = historyMaxSize;
    }

    public int getIdleInterval() {
        return this.idleInterval;
    }

    public void setIdleInterval(int idleInterval) {
        this.idleInterval = idleInterval;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    @Deprecated
    public void setStarted(boolean isStarted) {
        throw new UnsupportedOperationException();
    }

    public JbpmConfiguration getJbpmConfiguration() {
        return this.jbpmConfiguration;
    }

    public void setJbpmConfiguration(JbpmConfiguration jbpmConfiguration) {
        this.jbpmConfiguration = jbpmConfiguration;
    }

    public int getMaxIdleInterval() {
        return this.maxIdleInterval;
    }

    public void setMaxIdleInterval(int maxIdleInterval) {
        this.maxIdleInterval = maxIdleInterval;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Deprecated
    public int getSize() {
        return this.nbrOfThreads;
    }

    @Deprecated
    public void setSize(int nbrOfThreads) {
        this.nbrOfThreads = nbrOfThreads;
    }

    public Map<String, Thread> getThreads() {
        return this.threads;
    }

    @Deprecated
    public void setThreads(Map<String, Thread> threads) {
        throw new UnsupportedOperationException();
    }

    public int getMaxLockTime() {
        return this.maxLockTime;
    }

    public void setMaxLockTime(int maxLockTime) {
        this.maxLockTime = maxLockTime;
    }

    public int getLockBufferTime() {
        return this.lockBufferTime;
    }

    public void setLockBufferTime(int lockBufferTime) {
        this.lockBufferTime = lockBufferTime;
    }

    public int getLockMonitorInterval() {
        return this.lockMonitorInterval;
    }

    public void setLockMonitorInterval(int lockMonitorInterval) {
        this.lockMonitorInterval = lockMonitorInterval;
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    public void setNbrOfThreads(int nbrOfThreads) {
        this.nbrOfThreads = nbrOfThreads;
    }
}

