/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.el.impl;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.impl.BeanInfoIndexedProperty;
import org.jbpm.jpdl.el.impl.BeanInfoProperty;
import org.jbpm.jpdl.el.impl.BeanMethod;
import org.jbpm.jpdl.el.impl.Constants;
import org.jbpm.jpdl.el.impl.Logger;

public class BeanInfoManager {
    Class mBeanClass;
    BeanInfo mBeanInfo;
    Map mPropertyByName;
    Map mIndexedPropertyByName;
    Map mMethodByName;
    Map mEventSetByName;
    boolean mInitialized;
    static Map mBeanInfoManagerByClass = new HashMap();

    public Class getBeanClass() {
        return this.mBeanClass;
    }

    BeanInfoManager(Class pBeanClass) {
        this.mBeanClass = pBeanClass;
    }

    public static BeanInfoManager getBeanInfoManager(Class pClass) {
        BeanInfoManager ret = (BeanInfoManager)mBeanInfoManagerByClass.get(pClass);
        if (ret == null) {
            ret = BeanInfoManager.createBeanInfoManager(pClass);
        }
        return ret;
    }

    static synchronized BeanInfoManager createBeanInfoManager(Class pClass) {
        BeanInfoManager ret = (BeanInfoManager)mBeanInfoManagerByClass.get(pClass);
        if (ret == null) {
            ret = new BeanInfoManager(pClass);
            mBeanInfoManagerByClass.put(pClass, ret);
        }
        return ret;
    }

    public static BeanInfoProperty getBeanInfoProperty(Class pClass, String pPropertyName, Logger pLogger) throws ELException {
        return BeanInfoManager.getBeanInfoManager(pClass).getProperty(pPropertyName, pLogger);
    }

    public static BeanInfoIndexedProperty getBeanInfoIndexedProperty(Class pClass, String pIndexedPropertyName, Logger pLogger) throws ELException {
        return BeanInfoManager.getBeanInfoManager(pClass).getIndexedProperty(pIndexedPropertyName, pLogger);
    }

    public static BeanMethod getBeanMethod(Class pClass, String indexStr, Logger logger) throws ELException {
        return BeanInfoManager.getBeanInfoManager(pClass).getBeanMethod(indexStr, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInitialized(Logger pLogger) throws ELException {
        if (!this.mInitialized) {
            BeanInfoManager beanInfoManager = this;
            synchronized (beanInfoManager) {
                if (!this.mInitialized) {
                    this.initialize(pLogger);
                    this.mInitialized = true;
                }
            }
        }
    }

    void initialize(Logger pLogger) throws ELException {
        int i;
        block8: {
            try {
                this.mBeanInfo = Introspector.getBeanInfo(this.mBeanClass);
                this.mPropertyByName = new HashMap();
                this.mIndexedPropertyByName = new HashMap();
                this.mMethodByName = new HashMap();
                PropertyDescriptor[] pds = this.mBeanInfo.getPropertyDescriptors();
                int i2 = 0;
                while (pds != null && i2 < pds.length) {
                    PropertyDescriptor pd = pds[i2];
                    if (pd instanceof IndexedPropertyDescriptor) {
                        IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                        Method readMethod = BeanInfoManager.getPublicMethod(ipd.getIndexedReadMethod());
                        Method writeMethod = BeanInfoManager.getPublicMethod(ipd.getIndexedWriteMethod());
                        BeanInfoIndexedProperty property = new BeanInfoIndexedProperty(readMethod, writeMethod, ipd);
                        this.mIndexedPropertyByName.put(ipd.getName(), property);
                    }
                    Method readMethod = BeanInfoManager.getPublicMethod(pd.getReadMethod());
                    Method writeMethod = BeanInfoManager.getPublicMethod(pd.getWriteMethod());
                    BeanInfoProperty property = new BeanInfoProperty(readMethod, writeMethod, pd);
                    this.mPropertyByName.put(pd.getName(), property);
                    ++i2;
                }
                this.mEventSetByName = new HashMap();
                EventSetDescriptor[] esds = this.mBeanInfo.getEventSetDescriptors();
                i = 0;
                while (esds != null && i < esds.length) {
                    EventSetDescriptor esd = esds[i];
                    this.mEventSetByName.put(esd.getName(), esd);
                    ++i;
                }
            }
            catch (IntrospectionException exc) {
                if (!pLogger.isLoggingWarning()) break block8;
                pLogger.logWarning(Constants.EXCEPTION_GETTING_BEANINFO, exc, (Object)this.mBeanClass.getName());
            }
        }
        Class scannedClass = this.mBeanClass;
        while (scannedClass != null) {
            Method[] methods = scannedClass.getDeclaredMethods();
            i = 0;
            while (i < methods.length) {
                Method method = methods[i];
                if (!(this.mMethodByName.containsKey(method.getName()) || method.getParameterTypes() != null && method.getParameterTypes().length != 0)) {
                    this.mMethodByName.put(method.getName(), new BeanMethod(method));
                }
                ++i;
            }
            scannedClass = scannedClass.getSuperclass();
        }
    }

    BeanInfo getBeanInfo(Logger pLogger) throws ELException {
        this.checkInitialized(pLogger);
        return this.mBeanInfo;
    }

    public BeanInfoProperty getProperty(String pPropertyName, Logger pLogger) throws ELException {
        this.checkInitialized(pLogger);
        return (BeanInfoProperty)this.mPropertyByName.get(pPropertyName);
    }

    public BeanInfoIndexedProperty getIndexedProperty(String pIndexedPropertyName, Logger pLogger) throws ELException {
        this.checkInitialized(pLogger);
        return (BeanInfoIndexedProperty)this.mIndexedPropertyByName.get(pIndexedPropertyName);
    }

    public BeanMethod getBeanMethod(String pMethodName, Logger pLogger) throws ELException {
        this.checkInitialized(pLogger);
        return (BeanMethod)this.mMethodByName.get(pMethodName);
    }

    public EventSetDescriptor getEventSet(String pEventSetName, Logger pLogger) throws ELException {
        this.checkInitialized(pLogger);
        return (EventSetDescriptor)this.mEventSetByName.get(pEventSetName);
    }

    static Method getPublicMethod(Method pMethod) {
        if (pMethod == null) {
            return null;
        }
        Class<?> cl = pMethod.getDeclaringClass();
        if (Modifier.isPublic(cl.getModifiers())) {
            return pMethod;
        }
        Method ret = BeanInfoManager.getPublicMethod(cl, pMethod);
        if (ret != null) {
            return ret;
        }
        return pMethod;
    }

    static Method getPublicMethod(Class pClass, Method pMethod) {
        Method m;
        Class superclass;
        Class<?>[] interfaces;
        if (Modifier.isPublic(pClass.getModifiers())) {
            try {
                Method m2;
                try {
                    m2 = pClass.getDeclaredMethod(pMethod.getName(), pMethod.getParameterTypes());
                }
                catch (AccessControlException ex) {
                    m2 = pClass.getMethod(pMethod.getName(), pMethod.getParameterTypes());
                }
                if (Modifier.isPublic(m2.getModifiers())) {
                    return m2;
                }
            }
            catch (NoSuchMethodException m3) {
                // empty catch block
            }
        }
        if ((interfaces = pClass.getInterfaces()) != null) {
            int i = 0;
            while (i < interfaces.length) {
                Method m4 = BeanInfoManager.getPublicMethod(interfaces[i], pMethod);
                if (m4 != null) {
                    return m4;
                }
                ++i;
            }
        }
        if ((superclass = pClass.getSuperclass()) != null && (m = BeanInfoManager.getPublicMethod(superclass, pMethod)) != null) {
            return m;
        }
        return null;
    }
}

