/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.el.impl;

import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.impl.BinaryOperator;
import org.jbpm.jpdl.el.impl.Coercions;
import org.jbpm.jpdl.el.impl.Logger;
import org.jbpm.jpdl.el.impl.PrimitiveObjects;

public class OrOperator
extends BinaryOperator {
    public static final OrOperator SINGLETON = new OrOperator();

    @Override
    public String getOperatorSymbol() {
        return "or";
    }

    @Override
    public Object apply(Object pLeft, Object pRight, Logger pLogger) throws ELException {
        boolean left = Coercions.coerceToBoolean(pLeft, pLogger);
        boolean right = Coercions.coerceToBoolean(pRight, pLogger);
        return PrimitiveObjects.getBoolean(left || right);
    }

    @Override
    public boolean shouldEvaluate(Object pLeft) {
        return pLeft instanceof Boolean && (Boolean)pLeft == false;
    }

    @Override
    public boolean shouldCoerceToBoolean() {
        return true;
    }
}

