/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.jta;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import org.jbpm.JbpmException;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.persistence.jta.JtaDbPersistenceService;
import org.jbpm.svc.Service;

public class JtaDbPersistenceServiceFactory
extends DbPersistenceServiceFactory {
    private static final long serialVersionUID = 1L;
    private UserTransaction userTransaction;

    public JtaDbPersistenceServiceFactory() {
        this.setCurrentSessionEnabled(true);
        this.setTransactionEnabled(false);
    }

    @Override
    public Service openService() {
        return new JtaDbPersistenceService(this);
    }

    public UserTransaction getUserTransaction() {
        if (this.userTransaction == null) {
            String jndiName = this.getConfiguration().getProperty("jta.UserTransaction");
            if (jndiName == null) {
                jndiName = "java:comp/UserTransaction";
            }
            try {
                this.userTransaction = (UserTransaction)new InitialContext().lookup(jndiName);
            }
            catch (NamingException e) {
                throw new JbpmException("could not retrieve user transaction with name " + jndiName, e);
            }
        }
        return this.userTransaction;
    }
}

