/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.svc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.logging.LoggingService;
import org.jbpm.msg.MessageService;
import org.jbpm.persistence.JbpmPersistenceException;
import org.jbpm.persistence.PersistenceService;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;
import org.jbpm.scheduler.SchedulerService;
import org.jbpm.security.AuthenticationService;
import org.jbpm.security.AuthorizationService;
import org.jbpm.svc.JbpmServiceException;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.svc.save.CascadeSaveOperation;
import org.jbpm.svc.save.CheckUnpersistableVariablesOperation;
import org.jbpm.svc.save.HibernateSaveOperation;
import org.jbpm.svc.save.SaveLogsOperation;
import org.jbpm.svc.save.SaveOperation;
import org.jbpm.tx.TxService;

public class Services
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERVICENAME_AUTHENTICATION = "authentication";
    public static final String SERVICENAME_AUTHORIZATION = "authorization";
    public static final String SERVICENAME_TX = "tx";
    public static final String SERVICENAME_LOGGING = "logging";
    public static final String SERVICENAME_MESSAGE = "message";
    public static final String SERVICENAME_PERSISTENCE = "persistence";
    public static final String SERVICENAME_SCHEDULER = "scheduler";
    public static final String SERVICENAME_JCR = "jcr";
    public static final String SERVICENAME_ADDRESSRESOLVER = "addressresolver";
    static final List<SaveOperation> defaultSaveOperations = Services.createDefaultSaveOperations();
    Map<String, ServiceFactory> serviceFactories;
    Map<String, Service> services;
    List<String> serviceNames;
    List<SaveOperation> saveOperations;
    private static Log log = LogFactory.getLog(Services.class);

    private static List<SaveOperation> createDefaultSaveOperations() {
        SaveOperation[] operations = new SaveOperation[]{new CheckUnpersistableVariablesOperation(), new HibernateSaveOperation(), new SaveLogsOperation(), new CascadeSaveOperation()};
        return Arrays.asList(operations);
    }

    public static Service getCurrentService(String name) {
        return Services.getCurrentService(name, true);
    }

    public static Service getCurrentService(String name, boolean isRequired) {
        Service service = null;
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext != null) {
            service = jbpmContext.getServices().getService(name);
        }
        if (isRequired && service == null) {
            throw new JbpmServiceException("service '" + name + "' unavailable");
        }
        return service;
    }

    public Services(Map<String, ServiceFactory> serviceFactories) {
        this(serviceFactories, new ArrayList<String>((Collection)serviceFactories.keySet()), null);
    }

    public Services(Map<String, ServiceFactory> serviceFactories, List<String> serviceNames, List<SaveOperation> saveOperations) {
        this.serviceFactories = serviceFactories;
        this.serviceNames = serviceNames;
        this.saveOperations = saveOperations != null ? saveOperations : defaultSaveOperations;
    }

    public void setSaveOperations(List<SaveOperation> saveOperations) {
        if (saveOperations == null) {
            throw new IllegalArgumentException("saveOperations cannot be null");
        }
        this.saveOperations = saveOperations;
    }

    public void addSaveOperation(SaveOperation saveOperation) {
        if (saveOperation == null) {
            throw new IllegalArgumentException("saveOperation cannot be null");
        }
        if (this.saveOperations == defaultSaveOperations) {
            this.saveOperations = new ArrayList<SaveOperation>(defaultSaveOperations);
        }
        this.saveOperations.add(saveOperation);
    }

    public Map<String, ServiceFactory> getServiceFactories() {
        if (this.serviceFactories == null) {
            this.serviceFactories = new HashMap<String, ServiceFactory>();
        }
        return this.serviceFactories;
    }

    public ServiceFactory getServiceFactory(String name) {
        return this.getServiceFactories().get(name);
    }

    public boolean hasService(String name) {
        boolean hasService = false;
        if (this.services != null) {
            hasService = this.services.containsKey(name);
        }
        return hasService;
    }

    public Service getService(String name) {
        ServiceFactory serviceFactory;
        Service service;
        if (this.services == null) {
            this.services = new HashMap<String, Service>();
        }
        if ((service = this.services.get(name)) == null && (serviceFactory = this.getServiceFactory(name)) != null) {
            service = serviceFactory.openService();
            this.services.put(name, service);
        }
        return service;
    }

    public void save(ProcessInstance processInstance, JbpmContext jbpmContext) {
        if (log.isDebugEnabled()) {
            if (this.saveOperations == defaultSaveOperations) {
                log.debug((Object)"executing default save operations");
            } else {
                log.debug((Object)"executing custom save operations");
            }
        }
        for (SaveOperation saveOperation : this.saveOperations) {
            saveOperation.save(processInstance, jbpmContext);
        }
    }

    public AuthenticationService getAuthenticationService() {
        return (AuthenticationService)this.getService(SERVICENAME_AUTHENTICATION);
    }

    public AuthorizationService getAuthorizationService() {
        return (AuthorizationService)this.getService(SERVICENAME_AUTHORIZATION);
    }

    public LoggingService getLoggingService() {
        return (LoggingService)this.getService(SERVICENAME_LOGGING);
    }

    public MessageService getMessageService() {
        return (MessageService)this.getService(SERVICENAME_MESSAGE);
    }

    public PersistenceService getPersistenceService() {
        return (PersistenceService)this.getService(SERVICENAME_PERSISTENCE);
    }

    public SchedulerService getSchedulerService() {
        return (SchedulerService)this.getService(SERVICENAME_SCHEDULER);
    }

    public TxService getTxService() {
        return (TxService)this.getService(SERVICENAME_TX);
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.services.put(SERVICENAME_AUTHENTICATION, authenticationService);
    }

    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.services.put(SERVICENAME_AUTHORIZATION, authorizationService);
    }

    public void setLoggingService(LoggingService loggingService) {
        this.services.put(SERVICENAME_LOGGING, loggingService);
    }

    public void setMessageService(MessageService messageService) {
        this.services.put(SERVICENAME_MESSAGE, messageService);
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.services.put(SERVICENAME_PERSISTENCE, persistenceService);
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.services.put(SERVICENAME_SCHEDULER, schedulerService);
    }

    public void setTxService(TxService txService) {
        this.services.put(SERVICENAME_TX, txService);
    }

    public void close() {
        if (this.services != null) {
            Exception firstException = null;
            for (String serviceName : this.serviceNames) {
                Service service = this.services.get(serviceName);
                if (service == null) continue;
                try {
                    log.debug((Object)("closing service '" + serviceName + "': " + service));
                    service.close();
                }
                catch (JbpmPersistenceException e) {
                    if (DbPersistenceService.isStaleStateException(e)) {
                        log.info((Object)("optimistic locking failed, could not close service: " + serviceName));
                        StaleObjectLogConfigurer.getStaleObjectExceptionsLog().error((Object)("optimistic locking failed, could not close service: " + serviceName), (Throwable)e);
                    } else {
                        log.error((Object)("problem closing service '" + serviceName + "'"), (Throwable)e);
                    }
                    if (firstException != null) continue;
                    firstException = e;
                }
                catch (Exception e) {
                    log.error((Object)("problem closing service '" + serviceName + "'"), (Throwable)e);
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            if (firstException != null) {
                throw firstException instanceof JbpmException ? (JbpmException)firstException : new JbpmException("problem closing services", firstException);
            }
        }
    }

    public static void assignId(Object object) {
        Services services;
        JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
        if (jbpmContext != null && (services = jbpmContext.getServices()).hasService(SERVICENAME_PERSISTENCE)) {
            PersistenceService persistenceService = services.getPersistenceService();
            persistenceService.assignId(object);
        }
    }
}

