/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.svc.save;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.svc.save.SaveOperation;

public class CascadeSaveOperation
implements SaveOperation {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(CascadeSaveOperation.class);

    @Override
    public void save(ProcessInstance processInstance, JbpmContext jbpmContext) {
        log.debug((Object)("cascading save of '" + processInstance + "'"));
        HashSet<ProcessInstance> cascadedProcessInstances = new HashSet<ProcessInstance>();
        cascadedProcessInstances.add(processInstance);
        this.cascadeSave(processInstance.removeCascadeProcessInstances(), jbpmContext, cascadedProcessInstances);
    }

    void cascadeSave(Collection<ProcessInstance> cascadeProcessInstances, JbpmContext jbpmContext, Set<ProcessInstance> cascadedProcessInstances) {
        if (cascadeProcessInstances != null) {
            for (ProcessInstance cascadeInstance : cascadeProcessInstances) {
                this.saveCascadeInstance(cascadeInstance, jbpmContext, cascadedProcessInstances);
            }
        }
    }

    void saveCascadeInstance(ProcessInstance cascadeInstance, JbpmContext jbpmContext, Set<ProcessInstance> cascadedProcessInstances) {
        if (!cascadedProcessInstances.contains(cascadeInstance)) {
            Collection<ProcessInstance> cascadeProcessInstances = cascadeInstance.removeCascadeProcessInstances();
            log.debug((Object)("cascading save to process instance '" + cascadeInstance + "'"));
            jbpmContext.save(cascadeInstance);
            cascadedProcessInstances.add(cascadeInstance);
            this.cascadeSave(cascadeProcessInstances, jbpmContext, cascadedProcessInstances);
        }
    }
}

