/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.taskmgmt.def;

import org.jbpm.JbpmException;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.node.StartState;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.instantiation.Delegation;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.TaskController;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;

public class Task
extends GraphElement {
    private static final long serialVersionUID = 1L;
    public static final int PRIORITY_HIGHEST = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int PRIORITY_NORMAL = 3;
    public static final int PRIORITY_LOW = 4;
    public static final int PRIORITY_LOWEST = 5;
    protected boolean isBlocking = false;
    protected boolean isSignalling = true;
    protected String condition = null;
    protected String dueDate = null;
    protected int priority = 3;
    protected TaskNode taskNode = null;
    protected StartState startState = null;
    protected TaskMgmtDefinition taskMgmtDefinition = null;
    protected Swimlane swimlane = null;
    protected String actorIdExpression = null;
    protected String pooledActorsExpression = null;
    protected Delegation assignmentDelegation = null;
    protected TaskController taskController = null;
    static final String[] supportedEventTypes = new String[]{"task-create", "task-assign", "task-start", "task-end"};

    public static int parsePriority(String priorityText) {
        if ("highest".equalsIgnoreCase(priorityText)) {
            return 1;
        }
        if ("high".equalsIgnoreCase(priorityText)) {
            return 2;
        }
        if ("normal".equalsIgnoreCase(priorityText)) {
            return 3;
        }
        if ("low".equalsIgnoreCase(priorityText)) {
            return 4;
        }
        if ("lowest".equalsIgnoreCase(priorityText)) {
            return 5;
        }
        try {
            return Integer.parseInt(priorityText);
        }
        catch (NumberFormatException e) {
            throw new JbpmException("priority '" + priorityText + "' could not be parsed as a priority");
        }
    }

    public Task() {
    }

    public Task(String name) {
        this.name = name;
    }

    @Override
    public String[] getSupportedEventTypes() {
        return supportedEventTypes;
    }

    public void setTaskNode(TaskNode taskNode) {
        this.taskNode = taskNode;
    }

    public void setTaskMgmtDefinition(TaskMgmtDefinition taskMgmtDefinition) {
        this.taskMgmtDefinition = taskMgmtDefinition;
    }

    public void setAssignmentDelegation(Delegation assignmentDelegation) {
        this.actorIdExpression = null;
        this.pooledActorsExpression = null;
        this.assignmentDelegation = assignmentDelegation;
        this.swimlane = null;
    }

    public void setActorIdExpression(String actorIdExpression) {
        this.actorIdExpression = actorIdExpression;
        this.assignmentDelegation = null;
        this.swimlane = null;
    }

    public void setPooledActorsExpression(String pooledActorsExpression) {
        this.pooledActorsExpression = pooledActorsExpression;
        this.assignmentDelegation = null;
        this.swimlane = null;
    }

    public void setSwimlane(Swimlane swimlane) {
        this.actorIdExpression = null;
        this.pooledActorsExpression = null;
        this.assignmentDelegation = null;
        this.swimlane = swimlane;
    }

    @Override
    public GraphElement getParent() {
        if (this.taskNode != null) {
            return this.taskNode;
        }
        if (this.startState != null) {
            return this.startState;
        }
        return this.processDefinition;
    }

    public TaskMgmtDefinition getTaskMgmtDefinition() {
        return this.taskMgmtDefinition;
    }

    public Swimlane getSwimlane() {
        return this.swimlane;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public void setBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
    }

    public TaskNode getTaskNode() {
        return this.taskNode;
    }

    public String getActorIdExpression() {
        return this.actorIdExpression;
    }

    public String getPooledActorsExpression() {
        return this.pooledActorsExpression;
    }

    public Delegation getAssignmentDelegation() {
        return this.assignmentDelegation;
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(String duedate) {
        this.dueDate = duedate;
    }

    public TaskController getTaskController() {
        return this.taskController;
    }

    public void setTaskController(TaskController taskController) {
        this.taskController = taskController;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public StartState getStartState() {
        return this.startState;
    }

    public void setStartState(StartState startState) {
        this.startState = startState;
    }

    public boolean isSignalling() {
        return this.isSignalling;
    }

    public void setSignalling(boolean isSignalling) {
        this.isSignalling = isSignalling;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }
}

