/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command.impl;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.command.Command;
import org.jbpm.command.CommandService;

public class CommandServiceImpl
implements CommandService,
Serializable {
    protected final JbpmConfiguration jbpmConfiguration;
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CommandServiceImpl.class);

    public CommandServiceImpl(JbpmConfiguration jbpmConfiguration) {
        this.jbpmConfiguration = jbpmConfiguration;
    }

    public Object execute(Command command) {
        JbpmContext jbpmContext = this.jbpmConfiguration.createJbpmContext();
        try {
            log.debug((Object)("executing " + command));
            Object object = command.execute(jbpmContext);
            return object;
        }
        catch (RuntimeException e) {
            jbpmContext.setRollbackOnly();
            log.error((Object)("failed to execute " + command), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            jbpmContext.setRollbackOnly();
            log.error((Object)("failed to execute " + command), (Throwable)e);
            throw new JbpmException("failed to execute " + command, e);
        }
        finally {
            jbpmContext.close();
        }
    }
}

