/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.jbpm.JbpmException;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingSession {
    final Session session;
    final JbpmSession jbpmSession;
    private static final Log log = LogFactory.getLog(LoggingSession.class);

    public LoggingSession(JbpmSession jbpmSession) {
        this.session = jbpmSession.getSession();
        this.jbpmSession = jbpmSession;
    }

    public LoggingSession(Session session) {
        this.session = session;
        this.jbpmSession = null;
    }

    public Map<Token, List<ProcessLog>> findLogsByProcessInstance(long processInstanceId) {
        return this.findLogsByProcessInstance((ProcessInstance)this.session.load(ProcessInstance.class, (Serializable)Long.valueOf(processInstanceId)));
    }

    public Map<Token, List<ProcessLog>> findLogsByProcessInstance(ProcessInstance processInstance) {
        HashMap<Token, List<ProcessLog>> tokenLogs = new HashMap<Token, List<ProcessLog>>();
        try {
            this.collectTokenLogs(tokenLogs, processInstance.getRootToken());
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't get logs for " + processInstance, e);
        }
        return tokenLogs;
    }

    private void collectTokenLogs(Map<Token, List<ProcessLog>> tokenLogs, Token token) {
        tokenLogs.put(token, this.findLogsByToken(token));
        Map<String, Token> children = token.getChildren();
        if (children != null && !children.isEmpty()) {
            for (Token child : children.values()) {
                this.collectTokenLogs(tokenLogs, child);
            }
        }
    }

    public List<ProcessLog> findLogsByToken(long tokenId) {
        return this.findLogsByToken((Token)this.session.load(Token.class, (Serializable)Long.valueOf(tokenId)));
    }

    public List<ProcessLog> findLogsByToken(Token token) {
        try {
            Query query = this.session.getNamedQuery("LoggingSession.findLogsByToken");
            query.setEntity("token", (Object)token);
            return CollectionUtil.checkList(query.list(), ProcessLog.class);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't get logs for " + token, e);
        }
    }

    public void saveProcessLog(ProcessLog processLog) {
        try {
            this.session.save((Object)processLog);
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't save process log '" + processLog + "'", e);
        }
    }

    public ProcessLog loadProcessLog(long processLogId) {
        ProcessLog processLog = null;
        try {
            processLog = (ProcessLog)this.session.load(ProcessLog.class, (Serializable)new Long(processLogId));
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't load process log '" + processLogId + "'", e);
        }
        return processLog;
    }

    public ProcessLog getProcessLog(long processLogId) {
        ProcessLog processLog = null;
        try {
            processLog = (ProcessLog)this.session.get(ProcessLog.class, (Serializable)new Long(processLogId));
        }
        catch (Exception e) {
            this.handle(e);
            throw new JbpmException("couldn't get process log '" + processLogId + "'", e);
        }
        return processLog;
    }

    private void handle(Exception exception) {
        log.error((Object)exception);
        if (this.jbpmSession != null) {
            this.jbpmSession.handleException();
        }
    }
}

