/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.compatibility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.hbm2ddl.DatabaseMetadata;
import org.hibernate.util.JDBCExceptionReporter;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JbpmSchemaUpdate {
    private Configuration configuration;
    private Settings settings;
    private File outputFile;
    private String delimiter;
    private final List<Exception> exceptions = new ArrayList<Exception>();
    private static final Log log = LogFactory.getLog(JbpmSchemaUpdate.class);

    public JbpmSchemaUpdate(Configuration configuration) {
        this(configuration, configuration.getProperties());
    }

    public JbpmSchemaUpdate(Configuration configuration, Properties properties) {
        Properties copy = (Properties)properties.clone();
        PropertiesHelper.resolvePlaceHolders((Properties)copy);
        this.configuration = configuration;
        this.settings = configuration.buildSettings(copy);
    }

    public JbpmSchemaUpdate(Configuration configuration, Settings settings) {
        this.configuration = configuration;
        this.settings = settings;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean doUpdate = true;
            String propFile = null;
            File out = null;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("--")) {
                    if (args[i].equals("--quiet")) {
                        script = false;
                        continue;
                    }
                    if (args[i].startsWith("--properties=")) {
                        propFile = args[i].substring(13);
                        continue;
                    }
                    if (args[i].startsWith("--config=")) {
                        cfg.configure(args[i].substring(9));
                        continue;
                    }
                    if (args[i].startsWith("--text")) {
                        doUpdate = false;
                        continue;
                    }
                    if (args[i].startsWith("--naming=")) {
                        Class clazz = ReflectHelper.classForName((String)args[i].substring(9));
                        cfg.setNamingStrategy(clazz.asSubclass(NamingStrategy.class).newInstance());
                        continue;
                    }
                    if (!args[i].startsWith("--output=")) continue;
                    out = new File(args[i].substring(9));
                    continue;
                }
                cfg.addFile(args[i]);
            }
            if (propFile != null) {
                FileInputStream inStream = new FileInputStream(propFile);
                try {
                    Properties props = new Properties();
                    props.load(inStream);
                    cfg.addProperties(props);
                }
                finally {
                    ((InputStream)inStream).close();
                }
            }
            new JbpmSchemaUpdate(cfg).execute(script, doUpdate, out);
        }
        catch (Exception e) {
            log.error((Object)"Error running schema update", (Throwable)e);
        }
    }

    public void execute(boolean printScript, boolean doUpdate, File outputFile) {
        this.setOutputFile(outputFile);
        this.execute(printScript, doUpdate);
    }

    public void execute(boolean printScript, boolean doUpdate) {
        log.info((Object)"running schema update");
        this.exceptions.clear();
        try {
            String[] script = this.generateScript(doUpdate);
            if (printScript) {
                this.printScript(script);
            }
            if (this.outputFile != null) {
                this.writeFile(script);
            }
        }
        catch (SQLException e) {
            this.exceptions.add(e);
            log.error((Object)"database connection failed", (Throwable)e);
        }
        catch (IOException e) {
            this.exceptions.add(e);
            log.error((Object)("could not write file: " + this.outputFile), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] generateScript(boolean doUpdate) throws SQLException {
        ConnectionProvider connectionProvider = this.settings.getConnectionProvider();
        try {
            String[] stringArray;
            log.info((Object)"acquiring a connection");
            Connection connection = connectionProvider.getConnection();
            try {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                    connection.setAutoCommit(true);
                }
                log.info((Object)"fetching database metadata");
                Dialect dialect = this.settings.getDialect();
                DatabaseMetadata meta = new DatabaseMetadata(connection, dialect);
                log.info((Object)"generating schema update script");
                String[] script = this.configuration.generateSchemaUpdateScript(dialect, meta);
                if (doUpdate) {
                    log.info((Object)"updating schema");
                    this.doUpdate(script, connection);
                    log.info((Object)"schema update complete");
                }
                stringArray = script;
            }
            catch (Throwable throwable) {
                JDBCExceptionReporter.logAndClearWarnings((Connection)connection);
                connectionProvider.closeConnection(connection);
                throw throwable;
            }
            JDBCExceptionReporter.logAndClearWarnings((Connection)connection);
            connectionProvider.closeConnection(connection);
            return stringArray;
        }
        finally {
            connectionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(String[] script, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            for (int i = 0; i < script.length; ++i) {
                String sql = script[i];
                log.debug((Object)sql);
                try {
                    statement.execute(sql);
                    SQLWarning warning = statement.getWarnings();
                    if (warning == null) continue;
                    JDBCExceptionReporter.logWarnings((SQLWarning)warning);
                    continue;
                }
                catch (SQLException e) {
                    this.exceptions.add(e);
                    log.error((Object)("unsuccessful: " + sql));
                    log.error((Object)e.getMessage());
                }
            }
        }
        finally {
            statement.close();
        }
    }

    private void printScript(String[] script) {
        for (int i = 0; i < script.length; ++i) {
            System.out.println(script[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String[] script) throws IOException {
        FileWriter writer = new FileWriter(this.outputFile);
        String lineSeparator = System.getProperty("line.separator");
        try {
            for (int i = 0; i < script.length; ++i) {
                writer.write(script[i]);
                if (this.delimiter != null) {
                    writer.write(this.delimiter);
                }
                writer.write(lineSeparator);
            }
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }
}

