/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db.hibernate;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.Converter;
import org.jbpm.context.exe.JbpmType;
import org.jbpm.util.ClassLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converters {
    private static final Map<String, Converter<?, ?>> convertersByClassNames = new HashMap();
    private static final Map<String, Converter<?, ?>> convertersByDatabaseId = new HashMap();
    private static final Map<Converter<?, ?>, String> convertersIds = new HashMap();
    private static Log log = LogFactory.getLog(Converters.class);

    private Converters() {
    }

    public static Converter<?, ?> getConverterByClassName(String className) {
        Converter<?, ?> converter = convertersByClassNames.get(className);
        if (converter == null) {
            Class<Converter<?, ?>> converterClass = Converters.getConverterClass(className);
            try {
                converter = converterClass.newInstance();
            }
            catch (InstantiationException e) {
                log.debug((Object)("could not instantiate converter '" + className + "': " + e));
            }
            catch (IllegalAccessException e) {
                log.debug((Object)("could not access converter: '" + className + "': " + e));
            }
        }
        return converter;
    }

    public static Converter<?, ?> getConverterByDatabaseId(String databaseId) {
        if (convertersByDatabaseId.isEmpty()) {
            JbpmType.getJbpmTypes();
        }
        return convertersByDatabaseId.get(databaseId);
    }

    public static String getConverterId(Converter<?, ?> converter) {
        return convertersIds.get(converter);
    }

    public static void registerConverter(String databaseId, Converter<?, ?> converter) {
        if (databaseId.length() != 1) {
            throw new JbpmException("converter-ids must be of length 1 (to be stored in a char)");
        }
        if (convertersByDatabaseId.containsKey(databaseId)) {
            throw new JbpmException("duplicate converter id: '" + databaseId + "'");
        }
        log.debug((Object)("adding converter '" + databaseId + "', '" + converter + "'"));
        convertersByClassNames.put(converter.getClass().getName(), converter);
        convertersByDatabaseId.put(databaseId, converter);
        convertersIds.put(converter, databaseId);
    }

    private static Class<? extends Converter<?, ?>> getConverterClass(String className) {
        return ClassLoaderUtil.classForName(className).asSubclass(Converter.class);
    }
}

