/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.action;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.node.NodeTypes;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionTypes {
    static final Log log = LogFactory.getLog(ActionTypes.class);
    static Map<String, Class<? extends Action>> actionTypes = ActionTypes.initialiseActionTypes();
    static Map<Class<? extends Action>, String> actionNames = NodeTypes.createInverseMapping(actionTypes);

    public static Set<Class<? extends Action>> getActionTypes() {
        return actionNames.keySet();
    }

    public static Set<String> getActionNames() {
        return actionTypes.keySet();
    }

    public static Class<? extends Action> getActionType(String name) {
        return actionTypes.get(name);
    }

    public static String getActionName(Class<? extends Action> type) {
        return actionNames.get(type);
    }

    public static boolean hasActionName(String name) {
        return actionTypes.containsKey(name);
    }

    static Map<String, Class<? extends Action>> initialiseActionTypes() {
        HashMap<String, Class<? extends Action>> types = new HashMap<String, Class<? extends Action>>();
        String resource = JbpmConfiguration.Configs.getString("resource.action.types");
        InputStream actionTypesStream = ClassLoaderUtil.getStream(resource);
        Element actionTypesElement = XmlUtil.parseXmlInputStream(actionTypesStream).getDocumentElement();
        Iterator<Element> actionTypeIterator = XmlUtil.elementIterator(actionTypesElement, "action-type");
        while (actionTypeIterator.hasNext()) {
            Element actionTypeElement = actionTypeIterator.next();
            String elementTag = actionTypeElement.getAttribute("element");
            String className = actionTypeElement.getAttribute("class");
            try {
                Class<?> actionClass = ClassLoaderUtil.classForName(className);
                types.put(elementTag, actionClass.asSubclass(Action.class));
            }
            catch (Exception e) {
                log.debug((Object)("action '" + elementTag + "' will not be available. class '" + className + "' couldn't be loaded"));
            }
        }
        return types;
    }
}

