/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.Serializable;
import java.util.Map;
import org.dom4j.Element;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;
import org.jbpm.util.EqualsUtil;

public class Action
implements ActionHandler,
Parsable,
Serializable {
    private static final long serialVersionUID = 1L;
    long id = 0L;
    protected String name = null;
    protected boolean isPropagationAllowed = true;
    protected boolean isAsync = false;
    protected boolean isAsyncExclusive = false;
    protected Action referencedAction = null;
    protected Delegation actionDelegation = null;
    protected String actionExpression = null;
    protected Event event = null;
    protected ProcessDefinition processDefinition = null;

    public Action() {
    }

    public Action(Delegation actionDelegate) {
        this.actionDelegation = actionDelegate;
    }

    public String toString() {
        String toString = null;
        if (this.actionExpression != null) {
            toString = "Action(" + this.actionExpression + ')';
        } else {
            String className = this.getClass().getSimpleName();
            toString = this.name != null ? className + '(' + this.name + ')' : className + '@' + Integer.toHexString(this.hashCode());
        }
        return toString;
    }

    public void read(Element actionElement, JpdlXmlReader jpdlReader) {
        String asyncText;
        String expression = actionElement.attributeValue("expression");
        if (expression != null) {
            this.actionExpression = expression;
        } else if (actionElement.attribute("ref-name") != null) {
            jpdlReader.addUnresolvedActionReference(actionElement, this);
        } else if (actionElement.attribute("class") != null) {
            this.actionDelegation = new Delegation();
            this.actionDelegation.read(actionElement, jpdlReader);
        } else {
            jpdlReader.addWarning("action does not have class nor ref-name attribute " + actionElement.asXML());
        }
        String acceptPropagatedEvents = actionElement.attributeValue("accept-propagated-events");
        if ("false".equalsIgnoreCase(acceptPropagatedEvents) || "no".equalsIgnoreCase(acceptPropagatedEvents) || "off".equalsIgnoreCase(acceptPropagatedEvents)) {
            this.isPropagationAllowed = false;
        }
        if ("true".equalsIgnoreCase(asyncText = actionElement.attributeValue("async"))) {
            this.isAsync = true;
        } else if ("exclusive".equalsIgnoreCase(asyncText)) {
            this.isAsync = true;
            this.isAsyncExclusive = true;
        }
    }

    public void write(Element actionElement) {
        if (this.actionDelegation != null) {
            this.actionDelegation.write(actionElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext executionContext) throws Exception {
        ClassLoader surroundingClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JbpmConfiguration.getProcessClassLoader(executionContext.getProcessDefinition()));
            if (this.referencedAction != null) {
                this.referencedAction.execute(executionContext);
            } else if (this.actionExpression != null) {
                JbpmExpressionEvaluator.evaluate(this.actionExpression, executionContext);
            } else if (this.actionDelegation != null) {
                ActionHandler actionHandler = (ActionHandler)this.actionDelegation.getInstance();
                actionHandler.execute(executionContext);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(surroundingClassLoader);
        }
    }

    public void setName(String name) {
        if (this.processDefinition != null) {
            Map<String, Action> actionMap = this.processDefinition.getActions();
            if (this.name != name && actionMap != null) {
                actionMap.remove(this.name);
                actionMap.put(name, this);
            }
        }
        this.name = name;
    }

    public boolean equals(Object o) {
        return EqualsUtil.equals(this, o);
    }

    public boolean acceptsPropagatedEvents() {
        return this.isPropagationAllowed;
    }

    public boolean isPropagationAllowed() {
        return this.isPropagationAllowed;
    }

    public void setPropagationAllowed(boolean isPropagationAllowed) {
        this.isPropagationAllowed = isPropagationAllowed;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Event getEvent() {
        return this.event;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    public Delegation getActionDelegation() {
        return this.actionDelegation;
    }

    public void setActionDelegation(Delegation instantiatableDelegate) {
        this.actionDelegation = instantiatableDelegate;
    }

    public Action getReferencedAction() {
        return this.referencedAction;
    }

    public void setReferencedAction(Action referencedAction) {
        this.referencedAction = referencedAction;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public boolean isAsyncExclusive() {
        return this.isAsyncExclusive;
    }

    public String getActionExpression() {
        return this.actionExpression;
    }

    public void setActionExpression(String actionExpression) {
        this.actionExpression = actionExpression;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }
}

