/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.job.Job;

public class Timer
extends Job {
    private static final long serialVersionUID = 1L;
    private static final String dateFormat = "yyyy-MM-dd HH:mm:ss,SSS";
    static BusinessCalendar businessCalendar = new BusinessCalendar();
    String name;
    String repeat;
    String transitionName = null;
    Action action = null;
    GraphElement graphElement = null;
    private static Log log = LogFactory.getLog(Timer.class);

    public Timer() {
    }

    public Timer(Token token) {
        super(token);
    }

    public boolean execute(JbpmContext jbpmContext) throws Exception {
        jbpmContext.addAutoSaveProcessInstance(this.processInstance);
        ExecutionContext executionContext = new ExecutionContext(this.token);
        executionContext.setTimer(this);
        if (this.taskInstance != null) {
            executionContext.setTaskInstance(this.taskInstance);
        }
        if (this.graphElement != null) {
            this.graphElement.fireAndPropagateEvent("timer", executionContext);
        }
        if (this.action != null) {
            try {
                log.debug((Object)("executing " + this));
                if (this.graphElement != null) {
                    this.graphElement.executeAction(this.action, executionContext);
                } else {
                    this.action.execute(executionContext);
                }
            }
            catch (Exception actionException) {
                log.warn((Object)"timer action threw exception", (Throwable)actionException);
                if (this.graphElement != null) {
                    this.graphElement.raiseException(actionException, executionContext);
                    log.debug((Object)("timer exception got handled by '" + this.graphElement + "'"));
                }
                throw actionException;
            }
        }
        if (this.transitionName != null && this.exception == null && this.token.getNode().hasLeavingTransition(this.transitionName)) {
            this.token.signal(this.transitionName);
        }
        if (this.repeat != null) {
            Duration interval = new Duration(this.repeat);
            long currentTime = System.currentTimeMillis();
            Date repeatDate = this.dueDate;
            while ((repeatDate = businessCalendar.add(repeatDate, interval)).getTime() <= currentTime) {
            }
            log.debug((Object)("scheduling " + this + " for repeat on: " + Timer.formatDueDate(repeatDate)));
            this.dueDate = repeatDate;
            this.lockOwner = null;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder text = new StringBuilder("Timer");
        if (this.name != null || this.dueDate != null) {
            text.append('(');
            if (this.name != null) {
                text.append(this.name).append(",");
            }
            if (this.dueDate != null) {
                text.append(Timer.formatDueDate(this.dueDate)).append(",");
            }
            if (this.taskInstance != null) {
                text.append(this.taskInstance).append(",");
            }
            if (this.token != null) {
                text.append(this.token);
            } else if (this.processInstance != null) {
                text.append(this.processInstance);
            }
            text.append(')');
        }
        return text.toString();
    }

    public static String formatDueDate(Date date) {
        return new SimpleDateFormat(dateFormat).format(date);
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeat) {
        this.repeat = repeat;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public void setTransitionName(String transitionName) {
        this.transitionName = transitionName;
    }

    public GraphElement getGraphElement() {
        return this.graphElement;
    }

    public void setGraphElement(GraphElement graphElement) {
        this.graphElement = graphElement;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }
}

