/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.jbpm.JbpmConfiguration;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.action.ActionTypes;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ExceptionHandler;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.NodeCollection;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.NodeTypes;
import org.jbpm.graph.node.StartState;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.xml.JpdlParser;
import org.jbpm.jpdl.xml.Problem;
import org.jbpm.jpdl.xml.ProblemListener;
import org.jbpm.mail.Mail;
import org.jbpm.scheduler.def.CancelTimerAction;
import org.jbpm.scheduler.def.CreateTimerAction;
import org.jbpm.taskmgmt.def.Swimlane;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.def.TaskController;
import org.jbpm.taskmgmt.def.TaskMgmtDefinition;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpdlXmlReader
implements ProblemListener {
    private static final long serialVersionUID = 1L;
    protected InputSource inputSource = null;
    protected List<Problem> problems = new ArrayList<Problem>();
    protected ProblemListener problemListener = null;
    protected ProcessDefinition processDefinition = null;
    protected String initialNodeName = null;
    protected Collection<Object[]> unresolvedTransitionDestinations = null;
    protected Collection<Object[]> unresolvedActionReferences = null;
    protected Document document;
    private int timerNumber;
    private static final Log log = LogFactory.getLog(JpdlXmlReader.class);

    public JpdlXmlReader(InputSource inputSource) {
        this.inputSource = inputSource;
    }

    public JpdlXmlReader(InputSource inputSource, ProblemListener problemListener) {
        this.inputSource = inputSource;
        this.problemListener = problemListener;
    }

    public JpdlXmlReader(Reader reader) {
        this(new InputSource(reader));
    }

    public void close() throws IOException {
        InputStream byteStream = this.inputSource.getByteStream();
        if (byteStream != null) {
            byteStream.close();
        } else {
            Reader charStream = this.inputSource.getCharacterStream();
            if (charStream != null) {
                charStream.close();
            }
        }
        this.document = null;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    @Override
    public void addProblem(Problem problem) {
        this.problems.add(problem);
        if (this.problemListener != null) {
            this.problemListener.addProblem(problem);
        }
    }

    public void addError(String description) {
        log.error((Object)("invalid process xml: " + description));
        this.addProblem(new Problem(2, description));
    }

    public void addError(String description, Throwable exception) {
        log.error((Object)("invalid process xml: " + description), exception);
        this.addProblem(new Problem(2, description, exception));
    }

    public void addWarning(String description) {
        log.warn((Object)("process xml warning: " + description));
        this.addProblem(new Problem(3, description));
    }

    public ProcessDefinition readProcessDefinition() {
        this.processDefinition = ProcessDefinition.createNewProcessDefinition();
        this.problems = new ArrayList<Problem>();
        this.unresolvedTransitionDestinations = new ArrayList<Object[]>();
        this.unresolvedActionReferences = new ArrayList<Object[]>();
        try {
            this.document = JpdlParser.parse(this.inputSource, this);
            Element root = this.document.getRootElement();
            this.parseProcessDefinitionAttributes(root);
            String description = root.elementTextTrim("description");
            if (description != null) {
                this.processDefinition.setDescription(description);
            }
            this.readSwimlanes(root);
            this.readActions(root, null, null);
            this.readNodes(root, this.processDefinition);
            this.readEvents(root, this.processDefinition);
            this.readExceptionHandlers(root, this.processDefinition);
            this.readTasks(root, null);
            this.resolveTransitionDestinations();
            this.resolveActionReferences();
            this.verifySwimlaneAssignments();
        }
        catch (Exception e) {
            log.error((Object)"couldn't parse process definition", (Throwable)e);
            this.addProblem(new Problem(2, "couldn't parse process definition", e));
        }
        if (Problem.containsProblemsOfLevel(this.problems, 2)) {
            throw new JpdlException(this.problems);
        }
        if (this.problems != null) {
            for (Problem problem : this.problems) {
                log.warn((Object)("process parse warning: " + problem.getDescription()));
            }
        }
        return this.processDefinition;
    }

    protected void parseProcessDefinitionAttributes(Element root) {
        this.processDefinition.setName(root.attributeValue("name"));
        this.initialNodeName = root.attributeValue("initial");
    }

    protected void readSwimlanes(Element processDefinitionElement) {
        Iterator iter = processDefinitionElement.elementIterator("swimlane");
        TaskMgmtDefinition taskMgmtDefinition = this.processDefinition.getTaskMgmtDefinition();
        while (iter.hasNext()) {
            Element swimlaneElement = (Element)iter.next();
            String swimlaneName = swimlaneElement.attributeValue("name");
            if (swimlaneName == null) {
                this.addWarning("there's a swimlane without a name");
                continue;
            }
            Swimlane swimlane = new Swimlane(swimlaneName);
            Element assignmentElement = swimlaneElement.element("assignment");
            if (assignmentElement != null) {
                if (assignmentElement.attribute("actor-id") != null || assignmentElement.attribute("pooled-actors") != null) {
                    swimlane.setActorIdExpression(assignmentElement.attributeValue("actor-id"));
                    swimlane.setPooledActorsExpression(assignmentElement.attributeValue("pooled-actors"));
                } else {
                    Delegation assignmentDelegation = this.readAssignmentDelegation(assignmentElement);
                    swimlane.setAssignmentDelegation(assignmentDelegation);
                }
            }
            taskMgmtDefinition.addSwimlane(swimlane);
        }
    }

    public void readNodes(Element element, NodeCollection nodeCollection) {
        Iterator nodeElementIter = element.elementIterator();
        while (nodeElementIter.hasNext()) {
            Element nodeElement = (Element)nodeElementIter.next();
            String nodeName = nodeElement.getName();
            Class<? extends Node> nodeType = NodeTypes.getNodeType(nodeName);
            if (nodeType == null) continue;
            Node node = null;
            try {
                node = nodeType.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("couldn't instantiate node '" + nodeName + "', of type '" + nodeType.getName() + "'"), (Throwable)e);
                continue;
            }
            node.setProcessDefinition(this.processDefinition);
            if (node instanceof StartState && this.processDefinition.getStartState() != null) {
                this.addError("max one start-state allowed in a process");
                continue;
            }
            this.readNode(nodeElement, node, nodeCollection);
            node.read(nodeElement, this);
        }
    }

    public void readTasks(Element element, TaskNode taskNode) {
        List elements = element.elements("task");
        TaskMgmtDefinition tmd = this.processDefinition.getTaskMgmtDefinition();
        if (elements.size() > 0) {
            if (tmd == null) {
                tmd = new TaskMgmtDefinition();
            }
            this.processDefinition.addDefinition(tmd);
            for (Object taskElement : elements) {
                this.readTask((Element)taskElement, tmd, taskNode);
            }
        }
    }

    public Task readTask(Element taskElement, TaskMgmtDefinition taskMgmtDefinition, TaskNode taskNode) {
        Element taskControllerElement;
        String signallingText;
        String blockingText;
        Task task = new Task();
        task.setProcessDefinition(this.processDefinition);
        String name = taskElement.attributeValue("name");
        if (name != null) {
            task.setName(name);
            taskMgmtDefinition.addTask(task);
        } else if (taskNode != null) {
            task.setName(taskNode.getName());
            taskMgmtDefinition.addTask(task);
        }
        String description = taskElement.elementTextTrim("description");
        if (description != null) {
            task.setDescription(description);
        } else {
            task.setDescription(taskElement.attributeValue("description"));
        }
        String condition = taskElement.elementTextTrim("condition");
        if (condition != null) {
            task.setCondition(condition);
        } else {
            task.setCondition(taskElement.attributeValue("condition"));
        }
        this.readTaskTimers(taskElement, task);
        this.readEvents(taskElement, task);
        this.readExceptionHandlers(taskElement, task);
        String duedateText = taskElement.attributeValue("duedate");
        if (duedateText == null) {
            duedateText = taskElement.attributeValue("dueDate");
        }
        task.setDueDate(duedateText);
        String priorityText = taskElement.attributeValue("priority");
        if (priorityText != null) {
            task.setPriority(Task.parsePriority(priorityText));
        }
        if (taskNode != null) {
            taskNode.addTask(task);
        }
        if ((blockingText = taskElement.attributeValue("blocking")) != null && ("true".equalsIgnoreCase(blockingText) || "yes".equalsIgnoreCase(blockingText) || "on".equalsIgnoreCase(blockingText))) {
            task.setBlocking(true);
        }
        if ((signallingText = taskElement.attributeValue("signalling")) != null && ("false".equalsIgnoreCase(signallingText) || "no".equalsIgnoreCase(signallingText) || "off".equalsIgnoreCase(signallingText))) {
            task.setSignalling(false);
        }
        String swimlaneName = taskElement.attributeValue("swimlane");
        Element assignmentElement = taskElement.element("assignment");
        if (swimlaneName != null) {
            Swimlane swimlane = taskMgmtDefinition.getSwimlane(swimlaneName);
            if (swimlane == null) {
                this.addWarning("task references unknown swimlane '" + swimlaneName + "':" + taskElement.asXML());
            } else {
                task.setSwimlane(swimlane);
            }
        } else if (assignmentElement != null) {
            if (assignmentElement.attribute("actor-id") != null || assignmentElement.attribute("pooled-actors") != null) {
                task.setActorIdExpression(assignmentElement.attributeValue("actor-id"));
                task.setPooledActorsExpression(assignmentElement.attributeValue("pooled-actors"));
            } else {
                Delegation assignmentDelegation = this.readAssignmentDelegation(assignmentElement);
                task.setAssignmentDelegation(assignmentDelegation);
            }
        } else {
            log.info((Object)("process xml information: no swimlane or assignment specified for task '" + taskElement.asXML() + "'"));
        }
        String notificationsText = taskElement.attributeValue("notify");
        if (notificationsText != null && ("true".equalsIgnoreCase(notificationsText) || "on".equalsIgnoreCase(notificationsText) || "yes".equalsIgnoreCase(notificationsText))) {
            String notificationEvent = "task-assign";
            Event event = task.getEvent(notificationEvent);
            if (event == null) {
                event = new Event(notificationEvent);
                task.addEvent(event);
            }
            Delegation delegation = this.createMailDelegation(notificationEvent, null, null, null, null);
            Action action = new Action(delegation);
            action.setProcessDefinition(this.processDefinition);
            action.setName(task.getName());
            event.addAction(action);
        }
        if ((taskControllerElement = taskElement.element("controller")) != null) {
            task.setTaskController(this.readTaskController(taskControllerElement));
        }
        return task;
    }

    protected Delegation readAssignmentDelegation(Element assignmentElement) {
        Delegation assignmentDelegation = new Delegation();
        String expression = assignmentElement.attributeValue("expression");
        String actorId = assignmentElement.attributeValue("actor-id");
        String pooledActors = assignmentElement.attributeValue("pooled-actors");
        if (expression != null) {
            assignmentDelegation.setProcessDefinition(this.processDefinition);
            assignmentDelegation.setClassName("org.jbpm.identity.assignment.ExpressionAssignmentHandler");
            assignmentDelegation.setConfiguration("<expression>" + expression + "</expression>");
        } else if (actorId != null || pooledActors != null) {
            assignmentDelegation.setProcessDefinition(this.processDefinition);
            assignmentDelegation.setClassName("org.jbpm.taskmgmt.assignment.ActorAssignmentHandler");
            String configuration = "";
            if (actorId != null) {
                configuration = configuration + "<actorId>" + actorId + "</actorId>";
            }
            if (pooledActors != null) {
                configuration = configuration + "<pooledActors>" + pooledActors + "</pooledActors>";
            }
            assignmentDelegation.setConfiguration(configuration);
        } else {
            assignmentDelegation = new Delegation();
            assignmentDelegation.read(assignmentElement, this);
        }
        return assignmentDelegation;
    }

    protected TaskController readTaskController(Element taskControllerElement) {
        TaskController taskController = new TaskController();
        if (taskControllerElement.attributeValue("class") != null) {
            Delegation taskControllerDelegation = new Delegation();
            taskControllerDelegation.read(taskControllerElement, this);
            taskController.setTaskControllerDelegation(taskControllerDelegation);
        } else {
            List<VariableAccess> variableAccesses = this.readVariableAccesses(taskControllerElement);
            taskController.setVariableAccesses(variableAccesses);
        }
        return taskController;
    }

    public List<VariableAccess> readVariableAccesses(Element element) {
        ArrayList<VariableAccess> variableAccesses = new ArrayList<VariableAccess>();
        Iterator iter = element.elementIterator("variable");
        while (iter.hasNext()) {
            Element variableElement = (Element)iter.next();
            String variableName = variableElement.attributeValue("name");
            if (variableName == null) {
                this.addProblem(new Problem(3, "the name attribute of a variable element is required: " + variableElement.asXML()));
            }
            String access = variableElement.attributeValue("access", "read,write");
            String mappedName = variableElement.attributeValue("mapped-name");
            variableAccesses.add(new VariableAccess(variableName, access, mappedName));
        }
        return variableAccesses;
    }

    public void readStartStateTask(Element startTaskElement, StartState startState) {
        TaskMgmtDefinition taskMgmtDefinition = this.processDefinition.getTaskMgmtDefinition();
        Task startTask = this.readTask(startTaskElement, taskMgmtDefinition, null);
        startTask.setStartState(startState);
        if (startTask.getName() == null) {
            startTask.setName(startState.getName());
        }
        taskMgmtDefinition.setStartTask(startTask);
    }

    public void readNode(Element nodeElement, Node node, NodeCollection nodeCollection) {
        String asyncText;
        String description;
        nodeCollection.addNode(node);
        String name = nodeElement.attributeValue("name");
        if (name != null) {
            node.setName(name);
            if (this.initialNodeName != null && this.initialNodeName.equals(node.getFullyQualifiedName())) {
                this.processDefinition.setStartState(node);
            }
        }
        if ((description = nodeElement.elementTextTrim("description")) != null) {
            node.setDescription(description);
        }
        if ("true".equalsIgnoreCase(asyncText = nodeElement.attributeValue("async"))) {
            node.setAsync(true);
        } else if ("exclusive".equalsIgnoreCase(asyncText)) {
            node.setAsync(true);
            node.setAsyncExclusive(true);
        }
        this.readNodeTimers(nodeElement, node);
        this.readEvents(nodeElement, node);
        this.readExceptionHandlers(nodeElement, node);
        this.addUnresolvedTransitionDestination(nodeElement, node);
    }

    protected void readNodeTimers(Element nodeElement, Node node) {
        Iterator iter = nodeElement.elementIterator("timer");
        while (iter.hasNext()) {
            Element timerElement = (Element)iter.next();
            this.readNodeTimer(timerElement, node);
        }
    }

    protected void readNodeTimer(Element timerElement, Node node) {
        String name = timerElement.attributeValue("name", node.getName());
        if (name == null) {
            name = this.generateTimerName();
        }
        CreateTimerAction createTimerAction = this.instantiateCreateTimerAction();
        createTimerAction.read(timerElement, this);
        createTimerAction.setTimerName(name);
        createTimerAction.setTimerAction(this.readSingleAction(timerElement));
        this.addAction(node, "node-enter", createTimerAction);
        CancelTimerAction cancelTimerAction = this.instantiateCancelTimerAction();
        cancelTimerAction.setTimerName(name);
        this.addAction(node, "node-leave", cancelTimerAction);
    }

    private CreateTimerAction instantiateCreateTimerAction() {
        if (ActionTypes.hasActionName("create-timer")) {
            Class<? extends Action> actionType = ActionTypes.getActionType("create-timer");
            try {
                return (CreateTimerAction)actionType.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("couldn't instantiate 'create-timer' action of type '" + actionType.getName() + "'. Using default CreateTimerAction."), (Throwable)e);
            }
        }
        return new CreateTimerAction();
    }

    private CancelTimerAction instantiateCancelTimerAction() {
        if (ActionTypes.hasActionName("cancel-timer")) {
            Class<? extends Action> actionType = ActionTypes.getActionType("cancel-timer");
            try {
                return (CancelTimerAction)actionType.newInstance();
            }
            catch (Exception e) {
                log.error((Object)("couldn't instantiate 'cancel-timer' action of type '" + actionType.getName() + "'. Using default CancelTimerAction."), (Throwable)e);
            }
        }
        return new CancelTimerAction();
    }

    private String generateTimerName() {
        return "timer-" + this.timerNumber++;
    }

    protected void readTaskTimers(Element taskElement, Task task) {
        Iterator iter = taskElement.elementIterator();
        while (iter.hasNext()) {
            Element element = (Element)iter.next();
            if (!"timer".equals(element.getName()) && !"reminder".equals(element.getName())) continue;
            this.readTaskTimer(element, task);
        }
    }

    protected void readTaskTimer(Element timerElement, Task task) {
        String name = timerElement.attributeValue("name", task.getName());
        if (name == null) {
            name = this.generateTimerName();
        }
        CreateTimerAction createTimerAction = this.instantiateCreateTimerAction();
        createTimerAction.read(timerElement, this);
        createTimerAction.setTimerName(name);
        Action action = null;
        if ("timer".equals(timerElement.getName())) {
            action = this.readSingleAction(timerElement);
        } else {
            Delegation delegation = this.createMailDelegation("task-reminder", null, null, null, null);
            action = new Action(delegation);
        }
        createTimerAction.setTimerAction(action);
        this.addAction(task, "task-create", createTimerAction);
        ArrayList<String> cancelEventTypes = new ArrayList<String>();
        String cancelEventTypeText = timerElement.attributeValue("cancel-event");
        if (cancelEventTypeText != null) {
            StringTokenizer tokenizer = new StringTokenizer(cancelEventTypeText, ",");
            while (tokenizer.hasMoreTokens()) {
                cancelEventTypes.add(tokenizer.nextToken().trim());
            }
        } else {
            cancelEventTypes.add("task-end");
        }
        for (String cancelEventType : cancelEventTypes) {
            CancelTimerAction cancelTimerAction = this.instantiateCancelTimerAction();
            cancelTimerAction.setTimerName(name);
            this.addAction(task, cancelEventType, cancelTimerAction);
        }
    }

    protected void readEvents(Element parentElement, GraphElement graphElement) {
        Iterator iter = parentElement.elementIterator("event");
        while (iter.hasNext()) {
            Element eventElement = (Element)iter.next();
            String eventType = eventElement.attributeValue("type");
            if (!graphElement.hasEvent(eventType)) {
                graphElement.addEvent(new Event(eventType));
            }
            this.readActions(eventElement, graphElement, eventType);
        }
    }

    public void readActions(Element eventElement, GraphElement graphElement, String eventType) {
        Iterator nodeElementIter = eventElement.elementIterator();
        while (nodeElementIter.hasNext()) {
            Element actionElement = (Element)nodeElementIter.next();
            String actionName = actionElement.getName();
            if (!ActionTypes.hasActionName(actionName)) continue;
            Action action = this.createAction(actionElement);
            if (graphElement == null || eventType == null) continue;
            this.addAction(graphElement, eventType, action);
        }
    }

    protected void addAction(GraphElement graphElement, String eventType, Action action) {
        Event event = graphElement.getEvent(eventType);
        if (event == null) {
            event = new Event(eventType);
            graphElement.addEvent(event);
        }
        event.addAction(action);
    }

    public Action readSingleAction(Element nodeElement) {
        Action action = null;
        Iterator iter = nodeElement.elementIterator();
        while (iter.hasNext() && action == null) {
            Element candidate = (Element)iter.next();
            if (!ActionTypes.hasActionName(candidate.getName())) continue;
            action = this.createAction(candidate);
        }
        return action;
    }

    public Action createAction(Element actionElement) {
        Action action = null;
        String actionName = actionElement.getName();
        Class<? extends Action> actionType = ActionTypes.getActionType(actionName);
        try {
            action = actionType.newInstance();
        }
        catch (Exception e) {
            log.error((Object)("couldn't instantiate action '" + actionName + "', of type '" + actionType.getName() + "'"), (Throwable)e);
        }
        this.readAction(actionElement, action);
        return action;
    }

    public void readAction(Element element, Action action) {
        String actionName = element.attributeValue("name");
        if (actionName != null) {
            action.setName(actionName);
            this.processDefinition.addAction(action);
        }
        action.read(element, this);
    }

    protected void readExceptionHandlers(Element graphElementElement, GraphElement graphElement) {
        Iterator iter = graphElementElement.elementIterator("exception-handler");
        while (iter.hasNext()) {
            Element exceptionHandlerElement = (Element)iter.next();
            this.readExceptionHandler(exceptionHandlerElement, graphElement);
        }
    }

    protected void readExceptionHandler(Element exceptionHandlerElement, GraphElement graphElement) {
        ExceptionHandler exceptionHandler = new ExceptionHandler();
        exceptionHandler.setExceptionClassName(exceptionHandlerElement.attributeValue("exception-class"));
        graphElement.addExceptionHandler(exceptionHandler);
        Iterator iter = exceptionHandlerElement.elementIterator();
        while (iter.hasNext()) {
            Element childElement = (Element)iter.next();
            if (!ActionTypes.hasActionName(childElement.getName())) continue;
            Action action = this.createAction(childElement);
            exceptionHandler.addAction(action);
        }
    }

    public void addUnresolvedTransitionDestination(Element nodeElement, Node node) {
        this.unresolvedTransitionDestinations.add(new Object[]{nodeElement, node});
    }

    public void resolveTransitionDestinations() {
        for (Object[] unresolvedTransition : this.unresolvedTransitionDestinations) {
            Element nodeElement = (Element)unresolvedTransition[0];
            Node node = (Node)unresolvedTransition[1];
            this.resolveTransitionDestinations(nodeElement.elements("transition"), node);
        }
    }

    public void resolveTransitionDestinations(List<?> transitionElements, Node node) {
        for (Object transitionElement : transitionElements) {
            this.resolveTransitionDestination((Element)transitionElement, node);
        }
    }

    public Transition resolveTransitionDestination(Element transitionElement, Node node) {
        Element conditionElement;
        Transition transition = new Transition();
        transition.setProcessDefinition(this.processDefinition);
        transition.setName(transitionElement.attributeValue("name"));
        transition.setDescription(transitionElement.elementTextTrim("description"));
        String condition = transitionElement.attributeValue("condition");
        if (condition == null && (conditionElement = transitionElement.element("condition")) != null && ((condition = conditionElement.getTextTrim()) == null || condition.length() == 0)) {
            condition = conditionElement.attributeValue("expression");
        }
        transition.setCondition(condition);
        node.addLeavingTransition(transition);
        String toName = transitionElement.attributeValue("to");
        if (toName == null) {
            this.addWarning("node '" + node.getFullyQualifiedName() + "' has a transition without a 'to'-attribute to specify its destinationNode");
        } else {
            Node to = ((NodeCollection)((Object)node.getParent())).findNode(toName);
            if (to == null) {
                this.addWarning("transition to='" + toName + "' on node '" + node.getFullyQualifiedName() + "' cannot be resolved");
            } else {
                to.addArrivingTransition(transition);
            }
        }
        this.readActions(transitionElement, transition, "transition");
        this.readExceptionHandlers(transitionElement, transition);
        return transition;
    }

    public void addUnresolvedActionReference(Element actionElement, Action action) {
        this.unresolvedActionReferences.add(new Object[]{actionElement, action});
    }

    public void resolveActionReferences() {
        for (Object[] unresolvedActionReference : this.unresolvedActionReferences) {
            Element actionElement = (Element)unresolvedActionReference[0];
            Action action = (Action)unresolvedActionReference[1];
            String referencedActionName = actionElement.attributeValue("ref-name");
            Action referencedAction = this.processDefinition.getAction(referencedActionName);
            if (referencedAction == null) {
                this.addWarning("couldn't resolve action reference in " + actionElement.asXML());
            }
            action.setReferencedAction(referencedAction);
        }
    }

    public void verifySwimlaneAssignments() {
        TaskMgmtDefinition taskMgmtDefinition = this.processDefinition.getTaskMgmtDefinition();
        if (taskMgmtDefinition != null && taskMgmtDefinition.getSwimlanes() != null) {
            for (Swimlane swimlane : taskMgmtDefinition.getSwimlanes().values()) {
                Swimlane startTaskSwimlane;
                Task startTask = taskMgmtDefinition.getStartTask();
                Swimlane swimlane2 = startTaskSwimlane = startTask != null ? startTask.getSwimlane() : null;
                if (swimlane.getAssignmentDelegation() != null || swimlane.getActorIdExpression() != null || swimlane.getPooledActorsExpression() != null || swimlane == startTaskSwimlane) continue;
                this.addWarning("swimlane '" + swimlane.getName() + "' does not have an assignment");
            }
        }
    }

    public Delegation createMailDelegation(String template, String actors, String to, String subject, String text) {
        StringBuffer config = new StringBuffer();
        if (template != null) {
            config.append("<template>");
            config.append(template);
            config.append("</template>");
        }
        if (actors != null) {
            config.append("<actors>");
            config.append(actors);
            config.append("</actors>");
        }
        if (to != null) {
            config.append("<to>");
            config.append(to);
            config.append("</to>");
        }
        if (subject != null) {
            config.append("<subject>");
            config.append(subject);
            config.append("</subject>");
        }
        if (text != null) {
            config.append("<text>");
            config.append(text);
            config.append("</text>");
        }
        String mailClassName = Mail.class.getName();
        if (JbpmConfiguration.Configs.hasObject("jbpm.mail.class.name")) {
            mailClassName = JbpmConfiguration.Configs.getString("jbpm.mail.class.name");
        } else if (JbpmConfiguration.Configs.hasObject("mail.class.name")) {
            mailClassName = JbpmConfiguration.Configs.getString("mail.class.name");
        }
        Delegation delegation = new Delegation(mailClassName);
        delegation.setProcessDefinition(this.processDefinition);
        delegation.setConfiguration(config.toString());
        return delegation;
    }

    public String getProperty(String property, Element element) {
        Element propertyElement;
        String value = element.attributeValue(property);
        if (value == null && (propertyElement = element.element(property)) != null) {
            value = propertyElement.getText();
        }
        return value;
    }
}

