/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jbpm.util.ClassLoaderUtil;
import org.jbpm.util.XmlException;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    private XmlUtil() {
    }

    public static Document parseXmlText(String xml) {
        ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
        return XmlUtil.parseXmlInputSource(new InputSource(bais));
    }

    public static Document parseXmlResource(String resource, boolean isJbpmConfiguration) {
        InputStream inputStream = null;
        inputStream = isJbpmConfiguration ? ClassLoaderUtil.getJbpmConfigurationStream(resource) : ClassLoaderUtil.getStream(resource);
        if (inputStream == null) {
            throw new IllegalArgumentException("resource not found: " + resource);
        }
        return XmlUtil.parseXmlInputStream(inputStream);
    }

    public static Document parseXmlInputStream(InputStream inputStream) {
        Document document = null;
        try {
            document = XmlUtil.getDocumentBuilder().parse(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            throw new XmlException("could not read xml stream", e);
        }
        catch (SAXException e) {
            throw new XmlException("could not parse xml document", e);
        }
        return document;
    }

    public static Document parseXmlInputSource(InputSource inputSource) {
        Document document = null;
        try {
            document = XmlUtil.getDocumentBuilder().parse(inputSource);
        }
        catch (IOException e) {
            throw new XmlException("could not read xml stream", e);
        }
        catch (SAXException e) {
            throw new XmlException("could not parse xml document", e);
        }
        return document;
    }

    public static DocumentBuilder getDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new XmlException("could not create document builder", e);
        }
    }

    public static Iterator<Element> elementIterator(Element element, String tagName) {
        return XmlUtil.elements(element, tagName).iterator();
    }

    public static List<Element> elements(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        ArrayList<Element> elements = new ArrayList<Element>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getParentNode() != element) continue;
            elements.add((Element)child);
        }
        return elements;
    }

    public static Element element(Element element, String name) {
        Element childElement = null;
        NodeList nodeList = element.getElementsByTagName(name);
        if (nodeList.getLength() > 0) {
            childElement = (Element)nodeList.item(0);
        }
        return childElement;
    }

    public static Iterator<Element> elementIterator(Element element) {
        return XmlUtil.elements(element).iterator();
    }

    public static List<Element> elements(Element element) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            elements.add((Element)node);
        }
        return elements;
    }

    public static Element element(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    public static String toString(Element element) {
        if (element == null) {
            return "null";
        }
        DOMSource source = new DOMSource(element);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        StreamResult result = new StreamResult(printWriter);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new XmlException("couldn't write element '" + element.getTagName() + "' to string", e);
        }
        printWriter.close();
        return stringWriter.toString();
    }

    public static String getContentText(Element element) {
        StringBuilder text = new StringBuilder();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof CharacterData)) continue;
            CharacterData characterData = (CharacterData)node;
            text.append(characterData.getData());
        }
        return text.toString();
    }
}

