/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactory;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ValueInfo;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.instantiation.DefaultProcessClassLoaderFactory;
import org.jbpm.instantiation.ProcessClassLoaderFactory;
import org.jbpm.job.executor.JobExecutor;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.persistence.db.StaleObjectLogConfigurer;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.util.ClassLoaderUtil;

public class JbpmConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_RESOURCE = "jbpm.cfg.xml";
    private static ObjectFactory defaultObjectFactory;
    private static final Map instances;
    private static final ThreadLocal jbpmConfigurationStacks;
    private final ObjectFactory objectFactory;
    private final String resourceName;
    private JobExecutor jobExecutor;
    private boolean isClosed;
    private final ThreadLocal jbpmContextStacks = new StackThreadLocal();
    private static final Log log;
    static final /* synthetic */ boolean $assertionsDisabled;

    public JbpmConfiguration(ObjectFactory objectFactory) {
        this(objectFactory, null);
    }

    private JbpmConfiguration(ObjectFactory objectFactory, String resourceName) {
        this.objectFactory = objectFactory;
        this.resourceName = resourceName;
    }

    ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public static void setDefaultObjectFactory(ObjectFactory objectFactory) {
        defaultObjectFactory = objectFactory;
    }

    public static JbpmConfiguration getInstance() {
        return JbpmConfiguration.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JbpmConfiguration getInstance(String resource) {
        JbpmConfiguration instance;
        if (resource == null) {
            resource = DEFAULT_RESOURCE;
        }
        Map map = instances;
        synchronized (map) {
            instance = (JbpmConfiguration)instances.get(resource);
            if (instance == null) {
                if (defaultObjectFactory != null) {
                    log.info((Object)"configuring from default object factory");
                    instance = new JbpmConfiguration(defaultObjectFactory);
                } else {
                    log.info((Object)("configuring from resource: " + resource));
                    InputStream jbpmCfgXmlStream = ClassLoaderUtil.getStream(resource, false);
                    if (jbpmCfgXmlStream == null && !DEFAULT_RESOURCE.equals(resource)) {
                        log.warn((Object)("configuration resource not found: " + resource));
                    }
                    ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(jbpmCfgXmlStream);
                    instance = JbpmConfiguration.createJbpmConfiguration(objectFactory, resource);
                }
                instances.put(resource, instance);
            }
        }
        return instance;
    }

    public static boolean hasInstance(String resource) {
        return instances.containsKey(resource != null ? resource : DEFAULT_RESOURCE);
    }

    protected static ObjectFactory parseObjectFactory(InputStream inputStream) {
        ObjectFactoryParser objectFactoryParser = new ObjectFactoryParser();
        ObjectFactoryImpl objectFactoryImpl = new ObjectFactoryImpl();
        objectFactoryParser.parseElementsFromResource("org/jbpm/default.jbpm.cfg.xml", objectFactoryImpl);
        if (inputStream != null) {
            objectFactoryParser.parseElementsStream(inputStream, objectFactoryImpl);
        }
        return objectFactoryImpl;
    }

    public static JbpmConfiguration parseXmlString(String xml) {
        log.info((Object)"configuring from xml string");
        ByteArrayInputStream inputStream = xml != null ? new ByteArrayInputStream(xml.getBytes()) : null;
        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        return JbpmConfiguration.createJbpmConfiguration(objectFactory);
    }

    protected static JbpmConfiguration createJbpmConfiguration(ObjectFactory objectFactory) {
        return JbpmConfiguration.createJbpmConfiguration(objectFactory, null);
    }

    private static JbpmConfiguration createJbpmConfiguration(ObjectFactory objectFactory, String resourceName) {
        JbpmConfiguration jbpmConfiguration = new JbpmConfiguration(objectFactory, resourceName);
        if (objectFactory instanceof ObjectFactoryImpl) {
            ObjectFactoryImpl objectFactoryImpl = (ObjectFactoryImpl)objectFactory;
            ValueInfo jbpmConfigurationInfo = new ValueInfo("jbpmConfiguration", jbpmConfiguration);
            objectFactoryImpl.addObjectInfo(jbpmConfigurationInfo);
        }
        if (JbpmConfiguration.getHideStaleObjectExceptions(objectFactory)) {
            StaleObjectLogConfigurer.hideStaleObjectExceptions();
        }
        return jbpmConfiguration;
    }

    private static boolean getHideStaleObjectExceptions(ObjectFactory objectFactory) {
        Object hide;
        return !objectFactory.hasObject("jbpm.hide.stale.object.exceptions") || !Boolean.FALSE.equals(hide = objectFactory.createObject("jbpm.hide.stale.object.exceptions"));
    }

    public static JbpmConfiguration parseInputStream(InputStream inputStream) {
        log.info((Object)"configuring from input stream");
        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        return JbpmConfiguration.createJbpmConfiguration(objectFactory);
    }

    public static JbpmConfiguration parseResource(String resource) {
        log.info((Object)("configuring from resource: " + resource));
        InputStream inputStream = resource != null ? ClassLoaderUtil.getStream(resource, false) : null;
        ObjectFactory objectFactory = JbpmConfiguration.parseObjectFactory(inputStream);
        return JbpmConfiguration.createJbpmConfiguration(objectFactory, resource);
    }

    public JbpmContext createJbpmContext() {
        return this.createJbpmContext("default.jbpm.context");
    }

    public JbpmContext createJbpmContext(String name) {
        this.ensureOpen();
        JbpmContext jbpmContext = (JbpmContext)this.objectFactory.createObject(name);
        jbpmContext.setName(name);
        jbpmContext.setJbpmConfiguration(this);
        this.pushJbpmContext(jbpmContext);
        return jbpmContext;
    }

    public ServiceFactory getServiceFactory(String serviceName) {
        return this.getServiceFactory(serviceName, "default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceFactory getServiceFactory(String serviceName, String jbpmContextName) {
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            ServiceFactory serviceFactory = jbpmContext.getServices().getServiceFactory(serviceName);
            return serviceFactory;
        }
        finally {
            jbpmContext.close();
        }
    }

    private DbPersistenceServiceFactory getPersistenceServiceFactory(String jbpmContextName) {
        return (DbPersistenceServiceFactory)this.getServiceFactory("persistence", jbpmContextName);
    }

    public static ClassLoader getProcessClassLoader(ProcessDefinition processDefinition) {
        ProcessClassLoaderFactory factory = Configs.hasObject("process.class.loader.factory") ? (ProcessClassLoaderFactory)Configs.getObject("process.class.loader.factory") : new DefaultProcessClassLoaderFactory();
        return factory.getProcessClassLoader(processDefinition);
    }

    public void cleanSchema() {
        this.cleanSchema("default.jbpm.context");
    }

    public void cleanSchema(String jbpmContextName) {
        this.getPersistenceServiceFactory(jbpmContextName).cleanSchema();
    }

    public void createSchema() {
        this.createSchema("default.jbpm.context");
    }

    public void createSchema(String jbpmContextName) {
        this.getPersistenceServiceFactory(jbpmContextName).createSchema();
    }

    public void dropSchema() {
        this.dropSchema("default.jbpm.context");
    }

    public void dropSchema(String jbpmContextName) {
        this.getPersistenceServiceFactory(jbpmContextName).dropSchema();
    }

    private void ensureOpen() {
        if (this.isClosed) {
            throw new JbpmException(this + " is closed");
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public void close() {
        this.close("default.jbpm.context");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String jbpmContextName) {
        if (this.isClosed) {
            return;
        }
        if (this.jobExecutor != null) {
            this.jobExecutor.stop();
            this.jobExecutor = null;
        }
        JbpmContext jbpmContext = this.createJbpmContext(jbpmContextName);
        try {
            Map serviceFactories = jbpmContext.getServices().getServiceFactories();
            if (serviceFactories != null) {
                Iterator i = serviceFactories.values().iterator();
                while (i.hasNext()) {
                    ServiceFactory serviceFactory = (ServiceFactory)i.next();
                    serviceFactory.close();
                }
            }
        }
        finally {
            jbpmContext.close();
        }
        this.isClosed = true;
        this.jbpmContextStacks.set(null);
        if (this.resourceName != null) {
            Map map = instances;
            synchronized (map) {
                instances.remove(this.resourceName);
            }
        }
    }

    static JbpmConfiguration getCurrentJbpmConfiguration() {
        JbpmConfiguration currentJbpmConfiguration = null;
        List stack = JbpmConfiguration.getJbpmConfigurationStack();
        if (!stack.isEmpty()) {
            currentJbpmConfiguration = (JbpmConfiguration)stack.get(stack.size() - 1);
        }
        return currentJbpmConfiguration;
    }

    private static List getJbpmConfigurationStack() {
        return (List)jbpmConfigurationStacks.get();
    }

    static void clearJbpmConfigurationStack() {
        List configStack = JbpmConfiguration.getJbpmConfigurationStack();
        if (configStack != null) {
            JbpmConfiguration[] configs = configStack.toArray(new JbpmConfiguration[configStack.size()]);
            for (int f = 0; f < configs.length; ++f) {
                List contextStack = configs[f].getJbpmContextStack();
                if (contextStack != null) {
                    JbpmContext[] contexts = contextStack.toArray(new JbpmContext[contextStack.size()]);
                    for (int t = 0; t < contexts.length; ++t) {
                        contexts[t].close();
                    }
                }
                if (!$assertionsDisabled && !contextStack.isEmpty()) {
                    throw new AssertionError(contextStack);
                }
            }
            if (!$assertionsDisabled && !configStack.isEmpty()) {
                throw new AssertionError(configStack);
            }
        }
    }

    static void clearInstances() {
        instances.clear();
    }

    private void pushJbpmConfiguration() {
        JbpmConfiguration.getJbpmConfigurationStack().add(this);
    }

    private void popJbpmConfiguration() {
        List stack = JbpmConfiguration.getJbpmConfigurationStack();
        int index = stack.lastIndexOf(this);
        if (index == -1) {
            log.warn((Object)(this + " was not found in thread-local stack;" + "do not access JbpmContext instances from multiple threads"));
        } else {
            if (index != stack.size() - 1) {
                log.warn((Object)(this + " was not closed in reverse creation order;" + " check your try-finally clauses around JbpmContext blocks"));
            }
            stack.remove(index);
        }
    }

    public JbpmContext getCurrentJbpmContext() {
        this.ensureOpen();
        List stack = this.getJbpmContextStack();
        return stack.isEmpty() ? null : (JbpmContext)stack.get(stack.size() - 1);
    }

    private List getJbpmContextStack() {
        return (List)this.jbpmContextStacks.get();
    }

    void pushJbpmContext(JbpmContext jbpmContext) {
        this.pushJbpmConfiguration();
        this.getJbpmContextStack().add(jbpmContext);
    }

    void popJbpmContext(JbpmContext jbpmContext) {
        List stack = this.getJbpmContextStack();
        int index = stack.lastIndexOf(jbpmContext);
        if (index == -1) {
            log.warn((Object)(jbpmContext + " was not found in thread-local stack;" + " do not access JbpmContext instances from multiple threads"));
        } else {
            if (index != stack.size() - 1) {
                log.warn((Object)(jbpmContext + " was not closed in reverse creation order;" + " check your try-finally clauses around JbpmContext blocks"));
            }
            stack.remove(index);
        }
        this.popJbpmConfiguration();
    }

    public void startJobExecutor() {
        this.getJobExecutor().start();
    }

    public synchronized JobExecutor getJobExecutor() {
        this.ensureOpen();
        if (this.jobExecutor == null) {
            this.jobExecutor = (JobExecutor)this.objectFactory.createObject("jbpm.job.executor");
        }
        return this.jobExecutor;
    }

    public String toString() {
        return "JbpmConfiguration" + (this.resourceName != null ? '(' + this.resourceName + ')' : '@' + Integer.toHexString(this.hashCode()));
    }

    static {
        $assertionsDisabled = !JbpmConfiguration.class.desiredAssertionStatus();
        instances = new HashMap();
        jbpmConfigurationStacks = new StackThreadLocal();
        log = LogFactory.getLog((Class)JbpmConfiguration.class);
    }

    public static class Configs {
        private Configs() {
        }

        public static ObjectFactory getObjectFactory() {
            JbpmContext jbpmContext = JbpmContext.getCurrentJbpmContext();
            return jbpmContext != null ? jbpmContext.getObjectFactory() : JbpmConfiguration.getInstance().getObjectFactory();
        }

        public static void setDefaultObjectFactory(ObjectFactory objectFactory) {
            JbpmConfiguration.setDefaultObjectFactory(objectFactory);
        }

        public static boolean hasObject(String name) {
            ObjectFactory objectFactory = Configs.getObjectFactory();
            return objectFactory.hasObject(name);
        }

        public static synchronized Object getObject(String name) {
            ObjectFactory objectFactory = Configs.getObjectFactory();
            return objectFactory.createObject(name);
        }

        public static String getString(String name) {
            return (String)Configs.getObject(name);
        }

        public static long getLong(String name) {
            return (Long)Configs.getObject(name);
        }

        public static int getInt(String name) {
            return (Integer)Configs.getObject(name);
        }

        public static boolean getBoolean(String name) {
            return (Boolean)Configs.getObject(name);
        }
    }

    static class StackThreadLocal
    extends ThreadLocal {
        StackThreadLocal() {
        }

        protected Object initialValue() {
            return new ArrayList();
        }
    }
}

