/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.calendar;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.DayPart;

public class Day
implements Serializable {
    private static final long serialVersionUID = 1L;
    DayPart[] dayParts;
    BusinessCalendar businessCalendar;

    public static Day[] parseWeekDays(Properties calendarProperties, BusinessCalendar businessCalendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(calendarProperties.getProperty("hour.format"));
        String[] weekDayKeys = new String[]{null, "weekday.sunday", "weekday.monday", "weekday.tuesday", "weekday.wednesday", "weekday.thursday", "weekday.friday", "weekday.saturday"};
        Day[] weekDays = new Day[weekDayKeys.length];
        for (int i = 1; i <= 7; ++i) {
            weekDays[i] = new Day(calendarProperties.getProperty(weekDayKeys[i]), dateFormat, businessCalendar);
        }
        return weekDays;
    }

    public Day(String dayPartsText, DateFormat dateFormat, BusinessCalendar businessCalendar) {
        this.businessCalendar = businessCalendar;
        String[] dayPartTexts = dayPartsText.split("[\\s&]+");
        if (dayPartTexts.length > 1 || dayPartTexts[0].length() > 0) {
            this.dayParts = new DayPart[dayPartTexts.length];
            for (int i = 0; i < this.dayParts.length; ++i) {
                this.dayParts[i] = new DayPart(dayPartTexts[i], dateFormat, this, i);
            }
        } else {
            this.dayParts = new DayPart[0];
        }
    }

    public void findNextDayPartStart(int dayPartIndex, Date date, Object[] result) {
        if (dayPartIndex < this.dayParts.length) {
            if (this.dayParts[dayPartIndex].isStartAfter(date)) {
                result[0] = this.dayParts[dayPartIndex].getStartTime(date);
                result[1] = this.dayParts[dayPartIndex];
            } else {
                this.findNextDayPartStart(dayPartIndex + 1, date, result);
            }
        } else {
            date = this.businessCalendar.findStartOfNextDay(date);
            Day nextDay = this.businessCalendar.findDay(date);
            nextDay.findNextDayPartStart(0, date, result);
        }
    }
}

