/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.util.HashMap;
import java.util.List;
import org.jbpm.configuration.AbstractObjectInfo;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class MapInfo
extends AbstractObjectInfo {
    private static final long serialVersionUID = 1L;
    private ObjectInfo[] keyInfos;
    private ObjectInfo[] valueInfos;

    public MapInfo(Element mapElement, ObjectFactoryParser configParser) {
        super(mapElement, configParser);
        List entryElements = XmlUtil.elements(mapElement);
        this.keyInfos = new ObjectInfo[entryElements.size()];
        this.valueInfos = new ObjectInfo[entryElements.size()];
        for (int i = 0; i < entryElements.size(); ++i) {
            Element entryElement = (Element)entryElements.get(i);
            Element keyElement = XmlUtil.element(entryElement, "key");
            Element valueElement = XmlUtil.element(entryElement, "value");
            this.keyInfos[i] = configParser.parse(XmlUtil.element(keyElement));
            this.valueInfos[i] = configParser.parse(XmlUtil.element(valueElement));
        }
    }

    public Object createObject(ObjectFactoryImpl objectFactory) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (this.keyInfos != null) {
            for (int i = 0; i < this.keyInfos.length; ++i) {
                Object key = objectFactory.getObject(this.keyInfos[i]);
                Object value = objectFactory.getObject(this.valueInfos[i]);
                map.put(key, value);
            }
        }
        return map;
    }
}

