/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.configuration;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jbpm.JbpmException;
import org.jbpm.configuration.ObjectFactoryImpl;
import org.jbpm.configuration.ObjectFactoryParser;
import org.jbpm.configuration.ObjectInfo;
import org.jbpm.util.XmlUtil;
import org.w3c.dom.Element;

public class PropertyInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String propertyName;
    private String setterMethodName;
    private ObjectInfo propertyValueInfo;
    static /* synthetic */ Class class$java$lang$Object;

    public PropertyInfo(Element propertyElement, ObjectFactoryParser configParser) {
        if (propertyElement.hasAttribute("name")) {
            this.propertyName = propertyElement.getAttribute("name");
        } else if (propertyElement.hasAttribute("setter")) {
            this.setterMethodName = propertyElement.getAttribute("setter");
        } else {
            throw new JbpmException("missing name or setter attribute in property");
        }
        Element propertyValueElement = XmlUtil.element(propertyElement);
        this.propertyValueInfo = configParser.parse(propertyValueElement);
    }

    public void injectProperty(Object object, ObjectFactoryImpl objectFactory) {
        Method setterMethod = this.findSetter(object.getClass());
        setterMethod.setAccessible(true);
        Object value = objectFactory.getObject(this.propertyValueInfo);
        try {
            setterMethod.invoke(object, value);
        }
        catch (IllegalAccessException e) {
            throw new JbpmException(this.getClass() + " has no access to " + setterMethod, e);
        }
        catch (InvocationTargetException e) {
            throw new JbpmException(setterMethod + " threw exception", e.getCause());
        }
    }

    public Method findSetter(Class clazz) {
        if (this.setterMethodName == null) {
            this.setterMethodName = this.propertyName.startsWith("is") && this.propertyName.length() > 3 && Character.isUpperCase(this.propertyName.charAt(2)) ? "set" + this.propertyName.substring(2) : "set" + Character.toUpperCase(this.propertyName.charAt(0)) + this.propertyName.substring(1);
        }
        for (Class candidateClass = clazz; candidateClass != (class$java$lang$Object == null ? PropertyInfo.class$("java.lang.Object") : class$java$lang$Object); candidateClass = candidateClass.getSuperclass()) {
            Method[] methods = candidateClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(this.setterMethodName) || method.getParameterTypes().length != 1) continue;
                return method;
            }
        }
        throw new JbpmException("missing setter '" + this.setterMethodName + "' in " + clazz);
    }

    String getPropertyName() {
        return this.propertyName;
    }

    ObjectInfo getPropertyValueInfo() {
        return this.propertyValueInfo;
    }
}

