/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.Serializable;
import java.util.Map;
import org.dom4j.Element;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.instantiation.Delegation;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class Action
implements ActionHandler,
Parsable,
Serializable {
    private static final long serialVersionUID = 1L;
    long id;
    protected String name;
    protected boolean isPropagationAllowed = true;
    protected boolean isAsync;
    protected boolean isAsyncExclusive;
    protected Action referencedAction;
    protected Delegation actionDelegation;
    protected String actionExpression;
    protected Event event;
    protected ProcessDefinition processDefinition;

    public Action() {
    }

    public Action(Delegation actionDelegate) {
        this.actionDelegation = actionDelegate;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Action(");
        if (this.name != null) {
            result.append(this.name);
        } else if (this.actionDelegation != null) {
            result.append(this.actionDelegation);
        } else if (this.actionExpression != null) {
            result.append(this.actionExpression);
        } else if (this.referencedAction != null) {
            result.append(this.referencedAction.getName());
        }
        return result.append(')').toString();
    }

    public void read(Element actionElement, JpdlXmlReader jpdlReader) {
        String expression = actionElement.attributeValue("expression");
        if (expression != null) {
            this.actionExpression = expression;
        } else if (actionElement.attribute("ref-name") != null) {
            jpdlReader.addUnresolvedActionReference(actionElement, this);
        } else if (actionElement.attribute("class") != null) {
            this.actionDelegation = new Delegation();
            this.actionDelegation.read(actionElement, jpdlReader);
        } else {
            jpdlReader.addWarning("action does not have class nor ref-name attribute: " + actionElement.getPath());
        }
    }

    public void write(Element actionElement) {
        if (this.actionDelegation != null) {
            this.actionDelegation.write(actionElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext executionContext) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            ClassLoader processClassLoader = JbpmConfiguration.getProcessClassLoader(executionContext.getProcessDefinition());
            currentThread.setContextClassLoader(processClassLoader);
            if (this.referencedAction != null) {
                this.referencedAction.execute(executionContext);
            } else if (this.actionExpression != null) {
                JbpmExpressionEvaluator.evaluate(this.actionExpression, executionContext);
            } else if (this.actionDelegation != null) {
                ActionHandler actionHandler = (ActionHandler)this.actionDelegation.getInstance();
                actionHandler.execute(executionContext);
            }
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action other = (Action)o;
        if (this.id != 0L && this.id == other.getId()) {
            return true;
        }
        if (this.name != null) {
            return this.name.equals(other.getName()) && this.processDefinition.equals(other.getProcessDefinition());
        }
        return (this.actionDelegation != null ? this.actionDelegation.equals(other.getActionDelegation()) : (this.actionExpression != null ? this.actionExpression.equals(other.getActionExpression()) : this.referencedAction != null && this.referencedAction.equals(other.getActionExpression()))) && this.event.equals(other.getEvent());
    }

    public int hashCode() {
        int result = 1397928647;
        if (this.name != null) {
            result += this.name.hashCode();
            result = 1290535769 * result + this.processDefinition.hashCode();
        } else {
            if (this.actionDelegation != null) {
                result += this.actionDelegation.hashCode();
            } else if (this.actionExpression != null) {
                result += this.actionExpression.hashCode();
            } else if (this.referencedAction != null) {
                result += this.referencedAction.hashCode();
            }
            result = 1290535769 * result + this.event.hashCode();
        }
        return result;
    }

    public boolean acceptsPropagatedEvents() {
        return this.isPropagationAllowed;
    }

    public boolean isPropagationAllowed() {
        return this.isPropagationAllowed;
    }

    public void setPropagationAllowed(boolean isPropagationAllowed) {
        this.isPropagationAllowed = isPropagationAllowed;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.processDefinition != null) {
            Map actionMap = this.processDefinition.getActions();
            if (this.name != name && actionMap != null) {
                actionMap.remove(this.name);
                actionMap.put(name, this);
            }
        }
        this.name = name;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    public Delegation getActionDelegation() {
        return this.actionDelegation;
    }

    public void setActionDelegation(Delegation instantiatableDelegate) {
        this.actionDelegation = instantiatableDelegate;
    }

    public Action getReferencedAction() {
        return this.referencedAction;
    }

    public void setReferencedAction(Action referencedAction) {
        this.referencedAction = referencedAction;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public void setAsync(boolean isAsync) {
        this.isAsync = isAsync;
    }

    public boolean isAsyncExclusive() {
        return this.isAsyncExclusive;
    }

    public void setAsyncExclusive(boolean asyncExclusive) {
        this.isAsyncExclusive = asyncExclusive;
        if (asyncExclusive) {
            this.isAsync = true;
        }
    }

    public String getActionExpression() {
        return this.actionExpression;
    }

    public void setActionExpression(String actionExpression) {
        this.actionExpression = actionExpression;
    }
}

