/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.def;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmContext;
import org.jbpm.JbpmException;
import org.jbpm.util.Semaphore;

public class EventCallback
implements Serializable {
    public static final int DEFAULT_TIMEOUT = 300000;
    private static final long serialVersionUID = 1L;
    static final Log log = LogFactory.getLog((Class)EventCallback.class);
    private static Map eventSemaphores = new HashMap();

    public void processStart() {
        EventCallback.registerNotification("process-start");
    }

    public void processEnd() {
        EventCallback.registerNotification("process-end");
    }

    public void nodeEnter() {
        EventCallback.registerNotification("node-enter");
    }

    public void nodeLeave() {
        EventCallback.registerNotification("node-leave");
    }

    public void taskCreate() {
        EventCallback.registerNotification("task-create");
    }

    public void taskEnd() {
        EventCallback.registerNotification("task-end");
    }

    public void timerCreate() {
        EventCallback.registerNotification("timer-create");
    }

    public void timer() {
        EventCallback.registerNotification("timer");
    }

    public void transition() {
        EventCallback.registerNotification("transition");
    }

    private static void registerNotification(final String event) {
        Synchronization notification = new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                if (status == 3) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("sending '" + event + "' notification"));
                    }
                    Semaphore eventSemaphore = EventCallback.getEventSemaphore(event);
                    eventSemaphore.release();
                }
            }
        };
        JbpmContext.getCurrentJbpmContext().getSession().getTransaction().registerSynchronization(notification);
    }

    public static void waitForEvent(String event) {
        EventCallback.waitForEvent(1, event, 300000L);
    }

    public static void waitForEvent(String event, long timeout) {
        EventCallback.waitForEvent(1, event, timeout);
    }

    public static void waitForEvent(int occurrences, String event) {
        EventCallback.waitForEvent(occurrences, event, 300000L);
    }

    public static void waitForEvent(int occurrences, String event, long timeout) {
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("waiting for " + event));
        }
        Semaphore eventSemaphore = EventCallback.getEventSemaphore(event);
        try {
            if (!eventSemaphore.tryAcquire(occurrences, timeout)) {
                throw new JbpmException("event '" + event + "' did not occur within " + timeout + " ms");
            }
            if (debug) {
                log.debug((Object)("received '" + event + "' notification"));
            }
        }
        catch (InterruptedException e) {
            throw new JbpmException("wait for event '" + event + "' was interrupted", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Semaphore getEventSemaphore(String event) {
        Map map = eventSemaphores;
        synchronized (map) {
            Semaphore semaphore = (Semaphore)eventSemaphores.get(event);
            if (semaphore == null) {
                semaphore = new Semaphore(0);
                eventSemaphores.put(event, semaphore);
            }
            return semaphore;
        }
    }

    public static void clear() {
        Iterator i = eventSemaphores.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Semaphore semaphore = (Semaphore)entry.getValue();
            int permits = semaphore.drainPermits();
            if (permits == 0) continue;
            log.warn((Object)("event '" + entry.getKey() + "' has " + permits + " outstanding notifications"));
        }
    }
}

