/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.graph.log.ProcessStateLog;
import org.jbpm.graph.node.DbSubProcessResolver;
import org.jbpm.graph.node.SubProcessResolver;
import org.jbpm.jpdl.el.impl.JbpmExpressionEvaluator;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.util.Clock;

public class ProcessState
extends Node {
    private static final long serialVersionUID = 1L;
    private static SubProcessResolver defaultSubProcessResolver = new DbSubProcessResolver();
    protected ProcessDefinition subProcessDefinition;
    protected Set variableAccesses;
    protected String subProcessName;
    private static final String[] EVENT_TYPES = new String[]{"subprocess-created", "subprocess-end", "node-enter", "node-leave", "before-signal", "after-signal"};
    public static final String[] supportedEventTypes = (String[])EVENT_TYPES.clone();
    private static final Log log = LogFactory.getLog((Class)ProcessState.class);

    public static void setDefaultSubProcessResolver(SubProcessResolver subProcessResolver) {
        defaultSubProcessResolver = subProcessResolver;
    }

    public ProcessState() {
    }

    public ProcessState(String name) {
        super(name);
    }

    public String[] getSupportedEventTypes() {
        return (String[])EVENT_TYPES.clone();
    }

    public void read(Element processStateElement, JpdlXmlReader jpdlReader) {
        Element subProcessElement = processStateElement.element("sub-process");
        if (subProcessElement != null) {
            String binding = subProcessElement.attributeValue("binding");
            if ("late".equalsIgnoreCase(binding)) {
                this.subProcessName = subProcessElement.attributeValue("name");
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this + " will be late bound to process definition: " + this.subProcessName));
                }
            } else {
                this.subProcessDefinition = this.resolveSubProcess(subProcessElement, jpdlReader);
            }
        }
        this.variableAccesses = new HashSet(jpdlReader.readVariableAccesses(processStateElement));
    }

    private ProcessDefinition resolveSubProcess(Element subProcessElement, JpdlXmlReader jpdlReader) {
        SubProcessResolver subProcessResolver = this.getSubProcessResolver();
        try {
            ProcessDefinition subProcess = subProcessResolver.findSubProcess(subProcessElement);
            if (subProcess != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("bound " + this + " to " + subProcess));
                }
                return subProcess;
            }
        }
        catch (JbpmException e) {
            jpdlReader.addError("failed to resolve subprocess", e);
        }
        String subProcessName = subProcessElement.attributeValue("name");
        if (subProcessName != null && subProcessName.equals(this.processDefinition.getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("bound " + this + " to its own " + this.processDefinition));
            }
            return this.processDefinition;
        }
        return null;
    }

    private SubProcessResolver getSubProcessResolver() {
        return JbpmConfiguration.Configs.hasObject("jbpm.sub.process.resolver") ? (SubProcessResolver)JbpmConfiguration.Configs.getObject("jbpm.sub.process.resolver") : defaultSubProcessResolver;
    }

    public void execute(ExecutionContext executionContext) {
        Token superProcessToken = executionContext.getToken();
        ProcessDefinition usedSubProcessDefinition = this.subProcessDefinition;
        if (this.subProcessDefinition == null && this.subProcessName != null) {
            DefaultElement subProcessElement = new DefaultElement("sub-process");
            subProcessElement.addAttribute("name", (String)JbpmExpressionEvaluator.evaluate(this.subProcessName, executionContext, String.class));
            SubProcessResolver subProcessResolver = this.getSubProcessResolver();
            usedSubProcessDefinition = subProcessResolver.findSubProcess((Element)subProcessElement);
        }
        ProcessInstance subProcessInstance = superProcessToken.createSubProcessInstance(usedSubProcessDefinition);
        this.fireEvent("subprocess-created", executionContext);
        if (this.variableAccesses != null && !this.variableAccesses.isEmpty()) {
            ContextInstance superContextInstance = executionContext.getContextInstance();
            ContextInstance subContextInstance = subProcessInstance.getContextInstance();
            subContextInstance.setTransientVariables(superContextInstance.getTransientVariables());
            Iterator iter = this.variableAccesses.iterator();
            while (iter.hasNext()) {
                String variableName;
                Object value;
                VariableAccess variableAccess = (VariableAccess)iter.next();
                if (!variableAccess.isReadable() || (value = superContextInstance.getVariable(variableName = variableAccess.getVariableName(), superProcessToken)) == null) continue;
                String mappedName = variableAccess.getMappedName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(superProcessToken + " reads '" + variableName + "' into '" + mappedName + '\''));
                }
                subContextInstance.setVariable(mappedName, value);
            }
        }
        subProcessInstance.signal();
    }

    public void leave(ExecutionContext executionContext, Transition transition) {
        ProcessInstance subProcessInstance = executionContext.getSubProcessInstance();
        Token superProcessToken = subProcessInstance.getSuperProcessToken();
        if (this.variableAccesses != null && !this.variableAccesses.isEmpty()) {
            ContextInstance superContextInstance = executionContext.getContextInstance();
            ContextInstance subContextInstance = subProcessInstance.getContextInstance();
            Iterator iter = this.variableAccesses.iterator();
            while (iter.hasNext()) {
                String mappedName;
                Object value;
                VariableAccess variableAccess = (VariableAccess)iter.next();
                if (!variableAccess.isWritable() || (value = subContextInstance.getVariable(mappedName = variableAccess.getMappedName())) == null) continue;
                String variableName = variableAccess.getVariableName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(superProcessToken + " writes '" + variableName + "' from '" + mappedName + '\''));
                }
                superContextInstance.setVariable(variableName, value, superProcessToken);
            }
        }
        this.fireEvent("subprocess-end", executionContext);
        superProcessToken.setSubProcessInstance(null);
        superProcessToken.addLog(new ProcessStateLog(this, superProcessToken.getNodeEnter(), Clock.getCurrentTime(), subProcessInstance));
        super.leave(executionContext, this.getDefaultLeavingTransition());
    }

    protected void addNodeLog(Token token) {
    }

    public ProcessDefinition getSubProcessDefinition() {
        return this.subProcessDefinition;
    }

    public void setSubProcessDefinition(ProcessDefinition subProcessDefinition) {
        this.subProcessDefinition = subProcessDefinition;
    }
}

