/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.job.executor;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.job.executor.JobExecutorThread;
import org.jbpm.job.executor.LockMonitorThread;

public class JobExecutor
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected JbpmConfiguration jbpmConfiguration;
    protected String name;
    protected int nbrOfThreads;
    protected int idleInterval;
    protected int maxIdleInterval;
    protected int historyMaxSize;
    protected int maxLockTime;
    protected int lockMonitorInterval;
    protected int lockBufferTime;
    private ThreadGroup threadGroup;
    protected Map threads;
    protected LockMonitorThread lockMonitorThread;
    protected Map monitoredJobIds = new Hashtable();
    protected boolean isStarted;
    protected static String hostName;
    private static Log log;

    public synchronized void start() {
        if (!this.isStarted) {
            log.info((Object)("starting " + this.name));
            this.threadGroup = new ThreadGroup(this.name){

                public void uncaughtException(Thread thread, Throwable throwable) {
                    if (thread instanceof JobExecutorThread) {
                        JobExecutor.this.startThread(thread.getName());
                    } else if (thread instanceof LockMonitorThread) {
                        JobExecutor.this.startLockMonitorThread();
                    }
                    super.uncaughtException(thread, throwable);
                }
            };
            for (int i = 0; i < this.nbrOfThreads; ++i) {
                this.startThread();
            }
            this.startLockMonitorThread();
            this.isStarted = true;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("ignoring start: " + this.name + " already started'"));
        }
    }

    public synchronized List stop() {
        if (!this.isStarted) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("ignoring stop, " + this.name + " not started"));
            }
            return Collections.EMPTY_LIST;
        }
        log.info((Object)("stopping " + this.name));
        this.isStarted = false;
        Thread[] activeThreads = new Thread[this.threadGroup.activeCount()];
        int threadCount = this.threadGroup.enumerate(activeThreads);
        for (int i = 0; i < threadCount; ++i) {
            this.stopThread(activeThreads[i]);
        }
        return Arrays.asList(activeThreads);
    }

    public void stopAndJoin() throws InterruptedException {
        Iterator i = this.stop().iterator();
        while (i.hasNext()) {
            Thread thread = (Thread)i.next();
            thread.join();
        }
    }

    public void ensureThreadsAreActive() {
        int activeCount = this.threadGroup.activeCount();
        if (activeCount < this.nbrOfThreads + 1) {
            Thread[] activeThreads = new Thread[activeCount];
            activeCount = this.threadGroup.enumerate(activeThreads);
            for (int i = 1; i <= this.nbrOfThreads; ++i) {
                String threadName = this.getThreadName(i);
                if (JobExecutor.contains(activeThreads, activeCount, threadName)) continue;
                this.startThread(threadName);
            }
        }
    }

    private static boolean contains(Thread[] threads, int count, String threadName) {
        for (int i = 0; i < count; ++i) {
            if (!threadName.equals(threads[i].getName())) continue;
            return true;
        }
        return false;
    }

    ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    protected void startThread() {
        this.startThread(this.getNextThreadName());
    }

    protected void startThread(String threadName) {
        Thread thread = this.createThread(threadName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("starting " + threadName));
        }
        thread.start();
    }

    protected Thread createThread(String threadName) {
        return new JobExecutorThread(threadName, this);
    }

    protected String getNextThreadName() {
        return this.getThreadName(this.threadGroup.activeCount() + 1);
    }

    protected String getLastThreadName() {
        return this.getThreadName(this.threadGroup.activeCount());
    }

    protected synchronized Thread stopThread() {
        String threadName = this.getLastThreadName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("stopping " + threadName));
        }
        Thread thread = (Thread)this.threads.remove(threadName);
        this.stopThread(thread);
        return thread;
    }

    private void stopThread(Thread thread) {
        if (thread instanceof JobExecutorThread) {
            JobExecutorThread executor = (JobExecutorThread)thread;
            executor.deactivate();
        } else if (thread instanceof LockMonitorThread) {
            LockMonitorThread monitor = (LockMonitorThread)thread;
            monitor.deactivate();
        }
    }

    private String getThreadName(int index) {
        return this.name + '@' + JobExecutor.getHostAddress() + ":Executor-" + index;
    }

    void startLockMonitorThread() {
        String threadName = this.getLockMonitorThreadName();
        LockMonitorThread lockMonitorThread = new LockMonitorThread(threadName, this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("starting " + threadName));
        }
        lockMonitorThread.start();
    }

    private String getLockMonitorThreadName() {
        return this.name + '@' + JobExecutor.getHostAddress() + ':' + "Monitor";
    }

    private static String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }

    public Set getMonitoredJobIds() {
        return new HashSet(this.monitoredJobIds.values());
    }

    public void addMonitoredJobId(String threadName, long jobId) {
        this.monitoredJobIds.put(threadName, new Long(jobId));
    }

    public void removeMonitoredJobId(String threadName) {
        this.monitoredJobIds.remove(threadName);
    }

    public void setMonitoredJobIds(Map monitoredJobIds) {
    }

    public int getHistoryMaxSize() {
        return this.historyMaxSize;
    }

    public void setHistoryMaxSize(int historyMaxSize) {
        this.historyMaxSize = historyMaxSize;
    }

    public int getIdleInterval() {
        return this.idleInterval;
    }

    public void setIdleInterval(int idleInterval) {
        this.idleInterval = idleInterval;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setStarted(boolean isStarted) {
    }

    public JbpmConfiguration getJbpmConfiguration() {
        return this.jbpmConfiguration;
    }

    public void setJbpmConfiguration(JbpmConfiguration jbpmConfiguration) {
        this.jbpmConfiguration = jbpmConfiguration;
    }

    public int getMaxIdleInterval() {
        return this.maxIdleInterval;
    }

    public void setMaxIdleInterval(int maxIdleInterval) {
        this.maxIdleInterval = maxIdleInterval;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSize() {
        return this.nbrOfThreads;
    }

    public void setSize(int nbrOfThreads) {
        this.nbrOfThreads = nbrOfThreads;
    }

    public Map getThreads() {
        Thread[] threadList = new Thread[this.threadGroup.activeCount()];
        int threadCount = this.threadGroup.enumerate(threadList);
        HashMap<String, Thread> threadMap = new HashMap<String, Thread>(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            Thread thread = threadList[i];
            threadMap.put(thread.getName(), thread);
        }
        return threadMap;
    }

    public void setThreads(Map threads) {
    }

    public int getMaxLockTime() {
        return this.maxLockTime;
    }

    public void setMaxLockTime(int maxLockTime) {
        this.maxLockTime = maxLockTime;
    }

    public int getLockBufferTime() {
        return this.lockBufferTime;
    }

    public void setLockBufferTime(int lockBufferTime) {
        this.lockBufferTime = lockBufferTime;
    }

    public int getLockMonitorInterval() {
        return this.lockMonitorInterval;
    }

    public void setLockMonitorInterval(int lockMonitorInterval) {
        this.lockMonitorInterval = lockMonitorInterval;
    }

    public int getNbrOfThreads() {
        return this.nbrOfThreads;
    }

    public void setNbrOfThreads(int nbrOfThreads) {
        this.nbrOfThreads = nbrOfThreads;
    }

    static {
        log = LogFactory.getLog((Class)JobExecutor.class);
    }
}

