/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.persistence.db;

import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.jbpm.JbpmConfiguration;
import org.jbpm.db.JbpmSchema;
import org.jbpm.db.hibernate.HibernateHelper;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.svc.Service;
import org.jbpm.svc.ServiceFactory;
import org.jbpm.util.JndiUtil;

public class DbPersistenceServiceFactory
implements ServiceFactory {
    private static final long serialVersionUID = 1L;
    private Configuration configuration;
    String sessionFactoryJndiName;
    private SessionFactory sessionFactory;
    String dataSourceJndiName;
    private DataSource dataSource;
    boolean isTransactionEnabled = true;
    boolean isCurrentSessionEnabled;
    private SchemaExport schemaExport;
    private JbpmSchema jbpmSchema;

    public Service openService() {
        return new DbPersistenceService(this);
    }

    public synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            String hibernateCfgXmlResource = null;
            if (JbpmConfiguration.Configs.hasObject("resource.hibernate.cfg.xml")) {
                hibernateCfgXmlResource = JbpmConfiguration.Configs.getString("resource.hibernate.cfg.xml");
            }
            String hibernatePropertiesResource = null;
            if (JbpmConfiguration.Configs.hasObject("resource.hibernate.properties")) {
                hibernatePropertiesResource = JbpmConfiguration.Configs.getString("resource.hibernate.properties");
            }
            this.configuration = HibernateHelper.createConfiguration(hibernateCfgXmlResource, hibernatePropertiesResource);
        }
        return this.configuration;
    }

    public synchronized SchemaExport getSchemaExport() {
        if (this.schemaExport == null) {
            this.schemaExport = new SchemaExport(this.getConfiguration());
        }
        return this.schemaExport;
    }

    public synchronized JbpmSchema getJbpmSchema() {
        if (this.jbpmSchema == null) {
            this.jbpmSchema = new JbpmSchema(this.getConfiguration());
        }
        return this.jbpmSchema;
    }

    public synchronized SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.sessionFactoryJndiName != null ? (SessionFactory)JndiUtil.lookup(this.sessionFactoryJndiName, SessionFactory.class) : this.getConfiguration().buildSessionFactory();
        }
        return this.sessionFactory;
    }

    public DataSource getDataSource() {
        if (this.dataSource == null && this.dataSourceJndiName != null) {
            this.dataSource = (DataSource)JndiUtil.lookup(this.dataSourceJndiName, DataSource.class);
        }
        return this.dataSource;
    }

    public void cleanSchema() {
        this.getJbpmSchema().cleanSchema();
        HibernateHelper.clearHibernateCache(this.getSessionFactory());
    }

    public void createSchema() {
        this.getJbpmSchema().createSchema();
        HibernateHelper.clearHibernateCache(this.getSessionFactory());
    }

    public void dropSchema() {
        this.getJbpmSchema().dropSchema();
        HibernateHelper.clearHibernateCache(this.getSessionFactory());
    }

    boolean getScript() {
        boolean script = false;
        String showSql = this.getConfiguration().getProperty("hibernate.show_sql");
        if ("true".equalsIgnoreCase(showSql)) {
            script = true;
        }
        return script;
    }

    public void close() {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
    }

    public void finalize() throws Throwable {
        this.close();
    }

    public String getDataSourceJndiName() {
        return this.dataSourceJndiName;
    }

    public void setDataSourceJndiName(String dataSourceJndiName) {
        this.dataSourceJndiName = dataSourceJndiName;
    }

    public String getSessionFactoryJndiName() {
        return this.sessionFactoryJndiName;
    }

    public void setSessionFactoryJndiName(String sessionFactoryJndiName) {
        this.sessionFactoryJndiName = sessionFactoryJndiName;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setSchemaExport(SchemaExport schemaExport) {
        this.schemaExport = schemaExport;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public boolean isTransactionEnabled() {
        return this.isTransactionEnabled;
    }

    public void setTransactionEnabled(boolean isTransactionEnabled) {
        this.isTransactionEnabled = isTransactionEnabled;
    }

    public boolean isCurrentSessionEnabled() {
        return this.isCurrentSessionEnabled;
    }

    public void setCurrentSessionEnabled(boolean isCurrentSessionEnabled) {
        this.isCurrentSessionEnabled = isCurrentSessionEnabled;
    }
}

