/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class IoUtil {
    private static final int BUFFER_SIZE = 4096;
    public static final String lineSeparator = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("line.separator");
        }
    });

    private IoUtil() {
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IoUtil.transfer(in, out);
        return out.toByteArray();
    }

    public static int transfer(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        int total = 0;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            total += bytesRead;
        }
        return total;
    }
}

