/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.command;

import java.util.Date;
import org.jbpm.JbpmContext;
import org.jbpm.command.AbstractCancelCommand;
import org.jbpm.command.Command;
import org.jbpm.graph.exe.ProcessInstance;

public class CancelProcessInstanceCommand
extends AbstractCancelCommand
implements Command {
    private static final long serialVersionUID = 7145293049356621597L;
    private long processId;

    public CancelProcessInstanceCommand() {
    }

    public CancelProcessInstanceCommand(long processId) {
        this.processId = processId;
    }

    public Object execute(JbpmContext jbpmContext) throws Exception {
        this.jbpmContext = jbpmContext;
        this.cancelProcess(this.processId);
        this.jbpmContext = null;
        return null;
    }

    protected void cancelProcess(long processIdToCancel) {
        ProcessInstance pi = this.jbpmContext.getGraphSession().loadProcessInstance(processIdToCancel);
        log.info((Object)("cancel process instance " + pi.getId()));
        pi.getContextInstance().createVariable("cancelled", new Date());
        try {
            this.cancelToken(pi.getRootToken());
            this.cancelTokens(pi.getRootToken().getChildren().values());
            pi.end();
            log.info((Object)"finished process cancellation");
        }
        catch (RuntimeException ex) {
            log.error((Object)"problems while cancel process", (Throwable)ex);
            throw ex;
        }
    }

    public long getProcessId() {
        return this.processId;
    }

    public void setProcessId(long processId) {
        this.processId = processId;
    }
}

