/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.logging.exe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.graph.log.ActionLog;
import org.jbpm.logging.log.CompositeLog;
import org.jbpm.logging.log.ProcessLog;
import org.jbpm.module.exe.ModuleInstance;
import org.jbpm.util.Clock;

public class LoggingInstance
extends ModuleInstance {
    private static final long serialVersionUID = 1L;
    List logs = new ArrayList();
    transient LinkedList compositeLogStack = new LinkedList();
    private static final Log log = LogFactory.getLog(LoggingInstance.class);

    public void startCompositeLog(CompositeLog compositeLog) {
        this.addLog(compositeLog);
        this.compositeLogStack.addFirst(compositeLog);
    }

    public void endCompositeLog() {
        this.compositeLogStack.removeFirst();
    }

    public void addLog(ProcessLog processLog) {
        if (!this.compositeLogStack.isEmpty()) {
            CompositeLog currentCompositeLog = (CompositeLog)this.compositeLogStack.getFirst();
            processLog.setParent(currentCompositeLog);
            currentCompositeLog.addChild(processLog);
        }
        processLog.setDate(Clock.getCurrentTime());
        this.logs.add(processLog);
    }

    public List getLogs() {
        return this.logs;
    }

    public List getLogs(Class filterClass) {
        return LoggingInstance.getLogs(this.logs, filterClass);
    }

    public static List getLogs(Collection logs, Class filterClass) {
        ArrayList filteredLogs = new ArrayList();
        if (logs != null) {
            for (Object log : logs) {
                if (!filterClass.isAssignableFrom(log.getClass())) continue;
                filteredLogs.add(log);
            }
        }
        return filteredLogs;
    }

    LinkedList getCompositeLogStack() {
        return this.compositeLogStack;
    }

    List getCurrentOperationReversedActionLogs() {
        ArrayList<ProcessLog> actionLogs = new ArrayList<ProcessLog>();
        ProcessLog operationLog = (ProcessLog)this.compositeLogStack.getFirst();
        ListIterator listIterator = this.logs.listIterator(this.logs.size());
        ProcessLog processLog = (ProcessLog)listIterator.previous();
        while (listIterator.hasNext() && processLog != operationLog) {
            if (!(processLog instanceof ActionLog)) continue;
            actionLogs.add(0, processLog);
        }
        return actionLogs;
    }

    public void logLogs() {
        for (ProcessLog processLog : this.logs) {
            if (processLog.getParent() != null) continue;
            this.logLog("+-", processLog);
        }
    }

    void logLog(String indentation, ProcessLog processLog) {
        CompositeLog compositeLog;
        log.debug((Object)(processLog.getToken() + "[" + processLog.getIndex() + "] " + processLog + " on " + processLog.getToken()));
        if (processLog instanceof CompositeLog && (compositeLog = (CompositeLog)processLog).getChildren() != null) {
            Iterator iter = compositeLog.getChildren().iterator();
            while (iter.hasNext()) {
                this.logLog("| " + indentation, (ProcessLog)iter.next());
            }
        }
    }

    Object readResolve() {
        this.compositeLogStack = new LinkedList();
        return this;
    }
}

