/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmException;

public class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static Class loadClass(String className) {
        try {
            return ClassLoaderUtil.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new JbpmException("class not found '" + className + "'", e);
        }
    }

    public static ClassLoader getClassLoader() {
        if (JbpmConfiguration.Configs.hasObject("jbpm.classLoader")) {
            String jbpmClassloader = JbpmConfiguration.Configs.getString("jbpm.classLoader");
            if (jbpmClassloader.equals("jbpm")) {
                return ClassLoaderUtil.class.getClassLoader();
            }
            if (jbpmClassloader.equals("context")) {
                return Thread.currentThread().getContextClassLoader();
            }
            if (jbpmClassloader.equals("custom")) {
                String jbpmClassloaderClassname = null;
                try {
                    if (!JbpmConfiguration.Configs.hasObject("jbpm.customClassLoader.className")) {
                        throw new JbpmException("'jbpm.classloader' property set to 'custom' but 'jbpm.customClassLoader.className' is empty!");
                    }
                    jbpmClassloaderClassname = JbpmConfiguration.Configs.getString("jbpm.customClassLoader.className");
                    if (jbpmClassloaderClassname == null) {
                        throw new JbpmException("'jbpm.classloader' property set to 'custom' but 'jbpm.customClassLoader.className' is empty!");
                    }
                    Class<?> clazz = ClassLoaderUtil.class.getClassLoader().loadClass(jbpmClassloaderClassname);
                    if (clazz == null) {
                        clazz = Thread.currentThread().getContextClassLoader().loadClass(jbpmClassloaderClassname);
                    }
                    return (ClassLoader)clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new JbpmException("Error instantiating custom classloader " + jbpmClassloaderClassname, e);
                }
                catch (IllegalAccessException e) {
                    throw new JbpmException("Error accessing custom classloader " + jbpmClassloaderClassname, e);
                }
                catch (ClassNotFoundException e) {
                    throw new JbpmException("Custom classloader " + jbpmClassloaderClassname + " not found ", e);
                }
            }
            throw new JbpmException("'jbpm.classloader' property set to '" + jbpmClassloader + "' but only the values 'jbpm'/'context'/'custom' are supported!");
        }
        return ClassLoaderUtil.class.getClassLoader();
    }

    public static InputStream getStream(String resource) {
        return ClassLoaderUtil.getClassLoader().getResourceAsStream(resource);
    }

    public static InputStream getJbpmConfigurationStream(String resource) {
        InputStream jbpmCfgStream = ClassLoaderUtil.class.getClassLoader().getResourceAsStream(resource);
        if (jbpmCfgStream == null) {
            jbpmCfgStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        }
        return jbpmCfgStream;
    }

    public static Properties getProperties(String resource) {
        Properties properties = new Properties();
        try {
            InputStream inStream = ClassLoaderUtil.getStream(resource);
            properties.load(inStream);
            inStream.close();
        }
        catch (IOException e) {
            throw new JbpmException("couldn't load properties file '" + resource + "'", e);
        }
        return properties;
    }
}

