/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.def;

import desmoj.core.dist.Distribution;
import desmoj.core.dist.IntDist;
import desmoj.core.dist.RealDist;
import desmoj.core.simulator.Entity;
import desmoj.core.simulator.Experiment;
import desmoj.core.simulator.Model;
import desmoj.core.simulator.Queue;
import desmoj.core.simulator.SimTime;
import desmoj.core.statistic.Count;
import desmoj.core.statistic.Tally;
import desmoj.core.statistic.TimeSeries;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.node.EndState;
import org.jbpm.sim.SimulationConstants;
import org.jbpm.sim.def.DistributionDefinition;
import org.jbpm.sim.def.JbpmSimulationClock;
import org.jbpm.sim.def.LeavingTransitionProbabilityConfiguration;
import org.jbpm.sim.def.ResourcePool;
import org.jbpm.sim.def.ResourceRequirement;
import org.jbpm.sim.entity.ResourceUsingEntity;
import org.jbpm.sim.event.ProcessStartEventGenerator;
import org.jbpm.sim.exception.ExperimentConfigurationException;
import org.jbpm.sim.jpdl.SimulationDefinition;
import org.jbpm.sim.kpi.BusinessFigure;
import org.jbpm.taskmgmt.def.Task;
import org.jbpm.taskmgmt.exe.TaskInstance;

public abstract class JbpmSimulationModel
extends Model {
    private static Log log = LogFactory.getLog((Class)JbpmSimulationModel.class);
    private Map distributions = new HashMap();
    private Map resourcePools = new HashMap();
    private Map entityWaitTallies = new HashMap();
    private Map distributionMap = new HashMap();
    private Map leavingTransitionConfigurations = new HashMap();
    private Map resourceRequirements = new HashMap();
    private Map processCycleTimeTallies = new HashMap();
    private Map processEndStateCounts = new HashMap();
    private Map processStartCounts = new HashMap();
    private Map nameRegistry = new HashMap();
    private ArrayList endedProcessInstances = new ArrayList();
    private boolean rememberEndedProcessInstances = false;
    private Map businessFigures = new HashMap();
    static /* synthetic */ Class class$org$jbpm$sim$jpdl$SimulationDefinition;

    public JbpmSimulationModel(Model owner, String name) {
        super(owner, name, true, true);
    }

    public JbpmSimulationModel() {
        this(null, "JBoss jBPM simulation model");
    }

    public void connectToExperiment(Experiment exp) {
        super.connectToExperiment(exp);
        JbpmSimulationClock jbpmClock = (JbpmSimulationClock)JbpmConfiguration.Configs.getObject((String)"jbpm.date.generator");
        this.getExperiment().getSimClock().addObserver((Observer)jbpmClock);
    }

    public void init() {
        this.initResourcePools();
        this.initDistributions();
        this.initDistributionUsages();
        this.initResourceRequirements();
        this.initTransitionDistributions();
    }

    public void doInitialSchedules() {
        ProcessDefinition[] definitions = this.getProcessDefinitions();
        for (int i = 0; i < definitions.length; ++i) {
            SimTime processStartTime = this.getProcessStartTime(definitions[i]);
            if (processStartTime == null) {
                log.debug((Object)("process '" + definitions[i].getName() + "' has no start event distribution configured, it will not be started by the simulation framework"));
                continue;
            }
            log.debug((Object)("process '" + definitions[i].getName() + "' has a start event distribution configured and will be started by the simulation framework. The first start is at model time " + processStartTime));
            ProcessStartEventGenerator generator = new ProcessStartEventGenerator(this, definitions[i]);
            generator.schedule(processStartTime);
        }
    }

    public String description() {
        return "jBPM-Simulation";
    }

    public abstract ProcessDefinition[] getProcessDefinitions();

    public Distribution getDistribution(String name) {
        return (Distribution)this.distributions.get(name);
    }

    public boolean hasLeavingTransitionProbabilitiesConfigured(Node node) {
        return this.leavingTransitionConfigurations.containsKey(node);
    }

    public Transition getLeavingTransition(Node node) {
        LeavingTransitionProbabilityConfiguration conf = (LeavingTransitionProbabilityConfiguration)this.leavingTransitionConfigurations.get(node);
        if (conf == null) {
            log.debug((Object)("No transition probabilities configured for " + node + ", taking default transition"));
            return node.getDefaultLeavingTransition();
        }
        Transition transition = conf.decideOutgoingTransition();
        log.debug((Object)("Simulation engine decided for leaving " + transition + " for " + node));
        return transition;
    }

    public SimTime getTaskWorkingTime(Task task) {
        return this.getNextSimTimeWithDistributionMap(task);
    }

    public SimTime getStateWorkingTime(Node state) {
        return this.getNextSimTimeWithDistributionMap(state);
    }

    public SimTime getProcessStartTime(ProcessDefinition processDefinition) {
        return this.getNextSimTimeWithDistributionMap(processDefinition);
    }

    protected SimTime getNextSimTimeWithDistributionMap(Object key) {
        String distributionName = (String)this.distributionMap.get(key);
        if (distributionName == null) {
            log.warn((Object)("no distribution configured for element '" + key + "'"));
            return null;
        }
        Distribution dist = (Distribution)this.distributions.get(distributionName);
        if (dist == null) {
            throw new ExperimentConfigurationException("Distribution with name '" + distributionName + "' configured as event distribution for element '" + key + "' is not defined.");
        }
        SimTime result = this.getSimTimeFromDistribution(dist);
        log.debug((Object)("generated sim time " + result + " with distribution for element '" + key + "'"));
        return result;
    }

    private SimTime getSimTimeFromDistribution(Distribution dist) {
        if (IntDist.class.isAssignableFrom(dist.getClass())) {
            return new SimTime((double)this.getPositiveLong(((IntDist)dist).sample()));
        }
        if (RealDist.class.isAssignableFrom(dist.getClass())) {
            return new SimTime(this.getPositiveDouble(((RealDist)dist).sample()));
        }
        throw new ExperimentConfigurationException("Distribution class " + dist.getClass().getName() + " can not be used to construct time events");
    }

    private double getPositiveDouble(double d) {
        if (d < 0.0) {
            return -1.0 * d;
        }
        return d;
    }

    private long getPositiveLong(long l) {
        if (l < 0L) {
            return -1L * l;
        }
        return l;
    }

    public TimeSeries[] getResourceTimeSeries() {
        TimeSeries[] result = new TimeSeries[this.resourcePools.size()];
        int i = 0;
        Iterator iterator = this.resourcePools.values().iterator();
        while (iterator.hasNext()) {
            ResourcePool rp = (ResourcePool)iterator.next();
            result[i] = rp.getAvailableResourceTimeSeries();
            ++i;
        }
        return result;
    }

    public void addResourcePool(String poolName, int capacity, double costPerTimeUnit) {
        ResourcePool pool = new ResourcePool(this, poolName, capacity, costPerTimeUnit);
        this.resourcePools.put(poolName, pool);
        this.resourceUsageChanged(poolName);
    }

    public String[] getResourcePoolNames() {
        return this.resourcePools.keySet().toArray(new String[0]);
    }

    public ResourcePool getResourcePool(String poolName) {
        ResourcePool resourcePool = (ResourcePool)this.resourcePools.get(poolName);
        if (resourcePool == null) {
            throw new RuntimeException("pool " + poolName + " is not defined");
        }
        return resourcePool;
    }

    public void resourceUsageChanged(String poolName) {
        TimeSeries ts = this.getResourcePool(poolName).getAvailableResourceTimeSeries();
        ts.update((double)this.getResourcePool(poolName).getAvailableResources());
    }

    public Queue getResourcePoolQueue(String poolName) {
        return this.getResourcePool(poolName).getPool();
    }

    public TimeSeries getResourcePoolTimeSeries(String poolName) {
        return this.getResourcePool(poolName).getAvailableResourceTimeSeries();
    }

    public Queue getResourceQueue(String poolName) {
        Queue resourceQueue = this.getResourcePool(poolName).getResourceQueue();
        if (resourceQueue == null) {
            throw new RuntimeException("pool " + poolName + " is not defined");
        }
        return resourceQueue;
    }

    public void checkWaitingQueue(String poolName) {
        ResourceUsingEntity e;
        Queue q = this.getResourceQueue(poolName);
        if (!q.isEmpty() && (e = (ResourceUsingEntity)q.first()).resourceReleased(poolName)) {
            q.remove((Entity)e);
        }
    }

    public String formatTaskInstance(TaskInstance taskInstance) {
        return taskInstance.toString();
    }

    public ResourceRequirement[] getResourceRequirements(Object processElement) {
        List reqList = (List)this.resourceRequirements.get(processElement);
        if (reqList == null) {
            return new ResourceRequirement[0];
        }
        return reqList.toArray(new ResourceRequirement[0]);
    }

    public Tally getResourceWaitTimeTally(String poolName) {
        return this.getResourcePool(poolName).getWaitTimeTally();
    }

    public Tally getResourceWorkTimeTally(String poolName) {
        return this.getResourcePool(poolName).getWorkTimeTally();
    }

    public Tally getEntityWaitTimeTally(Object obj) {
        if (!this.entityWaitTallies.containsKey(obj)) {
            log.debug((Object)("Lazy initializing Histogram for Entity '" + obj + "'"));
            Tally result = new Tally((Model)this, this.buildName(obj, SimulationConstants.NAME_PREFIX_WAITING_BEFORE_STATE, SimulationConstants.NAME_SUFFIX_WAITING_BEFORE_STATE), true, false);
            result.reset();
            this.entityWaitTallies.put(obj, result);
            return result;
        }
        return (Tally)this.entityWaitTallies.get(obj);
    }

    private void initResourcePools() {
        HashMap<String, Integer> requiredPools = new HashMap<String, Integer>();
        HashMap<String, Double> resourceCosts = new HashMap<String, Double>();
        for (int i = 0; i < this.getProcessDefinitions().length; ++i) {
            SimulationDefinition simulationDefinition = (SimulationDefinition)this.getProcessDefinitions()[i].getDefinition(class$org$jbpm$sim$jpdl$SimulationDefinition == null ? JbpmSimulationModel.class$("org.jbpm.sim.jpdl.SimulationDefinition") : class$org$jbpm$sim$jpdl$SimulationDefinition);
            Iterator iterator = simulationDefinition.getResourcePoolDefinitions().keySet().iterator();
            while (iterator.hasNext()) {
                String poolName = (String)iterator.next();
                Object[] def = (Object[])simulationDefinition.getResourcePoolDefinitions().get(poolName);
                Integer poolSize = (Integer)def[0];
                Double costs = (Double)def[1];
                if (requiredPools.containsKey(poolName)) {
                    Integer otherPoolSize = (Integer)requiredPools.get(poolName);
                    if (poolSize > otherPoolSize) {
                        requiredPools.put(poolName, poolSize);
                        resourceCosts.put(poolName, costs);
                        log.warn((Object)("resource pool '" + poolName + "' redefined in process '" + this.getProcessDefinitions()[i].getName() + "' with the bigger poolsize " + poolSize + ", was " + otherPoolSize + " before"));
                        continue;
                    }
                    if (poolSize >= otherPoolSize) continue;
                    log.warn((Object)("resource pool '" + poolName + "' redefined in process '" + this.getProcessDefinitions()[i].getName() + "' with the smaler poolsize " + poolSize + " which is ignored. Poolsize still is " + otherPoolSize));
                    continue;
                }
                requiredPools.put(poolName, poolSize);
                resourceCosts.put(poolName, costs);
            }
        }
        Iterator iterator = requiredPools.keySet().iterator();
        while (iterator.hasNext()) {
            String poolName = (String)iterator.next();
            Integer capacity = (Integer)requiredPools.get(poolName);
            Double costs = (Double)resourceCosts.get(poolName);
            this.addResourcePool(poolName, capacity, costs);
        }
    }

    private void initDistributions() {
        for (int i = 0; i < this.getProcessDefinitions().length; ++i) {
            SimulationDefinition simulationDefinition = (SimulationDefinition)this.getProcessDefinitions()[i].getDefinition(class$org$jbpm$sim$jpdl$SimulationDefinition == null ? JbpmSimulationModel.class$("org.jbpm.sim.jpdl.SimulationDefinition") : class$org$jbpm$sim$jpdl$SimulationDefinition);
            Iterator iterator = simulationDefinition.getDistributions().iterator();
            while (iterator.hasNext()) {
                DistributionDefinition distDef = (DistributionDefinition)iterator.next();
                if (this.distributions.containsKey(distDef.getName())) {
                    throw new RuntimeException("duplicate definition of distribution '" + distDef.getName() + "'");
                }
                this.distributions.put(distDef.getName(), distDef.createDistribution(this));
            }
        }
    }

    private void initDistributionUsages() {
        for (int i = 0; i < this.getProcessDefinitions().length; ++i) {
            SimulationDefinition simulationDefinition = (SimulationDefinition)this.getProcessDefinitions()[i].getDefinition(class$org$jbpm$sim$jpdl$SimulationDefinition == null ? JbpmSimulationModel.class$("org.jbpm.sim.jpdl.SimulationDefinition") : class$org$jbpm$sim$jpdl$SimulationDefinition);
            this.distributionMap.putAll(simulationDefinition.getDistributionMap());
        }
    }

    private void initTransitionDistributions() {
        for (int i = 0; i < this.getProcessDefinitions().length; ++i) {
            SimulationDefinition simulationDefinition = (SimulationDefinition)this.getProcessDefinitions()[i].getDefinition(class$org$jbpm$sim$jpdl$SimulationDefinition == null ? JbpmSimulationModel.class$("org.jbpm.sim.jpdl.SimulationDefinition") : class$org$jbpm$sim$jpdl$SimulationDefinition);
            Iterator iterator = simulationDefinition.getTransitionProbabilities().keySet().iterator();
            while (iterator.hasNext()) {
                Transition trans = (Transition)iterator.next();
                double probability = (Double)simulationDefinition.getTransitionProbabilities().get(trans);
                if (this.leavingTransitionConfigurations.get(trans.getFrom()) == null) {
                    this.leavingTransitionConfigurations.put(trans.getFrom(), new LeavingTransitionProbabilityConfiguration(trans.getFrom(), trans, probability));
                    continue;
                }
                LeavingTransitionProbabilityConfiguration conf = (LeavingTransitionProbabilityConfiguration)this.leavingTransitionConfigurations.get(trans.getFrom());
                conf.addTransition(trans, probability);
            }
        }
        Iterator iterator = this.leavingTransitionConfigurations.values().iterator();
        while (iterator.hasNext()) {
            LeavingTransitionProbabilityConfiguration conf = (LeavingTransitionProbabilityConfiguration)iterator.next();
            conf.createDistribution(this);
        }
    }

    private void initResourceRequirements() {
        for (int i = 0; i < this.getProcessDefinitions().length; ++i) {
            SimulationDefinition simulationDefinition = (SimulationDefinition)this.getProcessDefinitions()[i].getDefinition(class$org$jbpm$sim$jpdl$SimulationDefinition == null ? JbpmSimulationModel.class$("org.jbpm.sim.jpdl.SimulationDefinition") : class$org$jbpm$sim$jpdl$SimulationDefinition);
            this.resourceRequirements.putAll(simulationDefinition.getResourceRequirements());
        }
    }

    public void reportProcessInstanceCycleTime(ProcessDefinition pd, double duration) {
        Tally tally = (Tally)this.processCycleTimeTallies.get(pd);
        if (tally == null) {
            tally = new Tally((Model)this, this.buildName(pd, SimulationConstants.NAME_PREFIX_PROCESS_CYCLE_TIME, SimulationConstants.NAME_SUFFIX_PROCESS_CYCLE_TIME), true, false);
            tally.reset();
            this.processCycleTimeTallies.put(pd, tally);
        }
        tally.update(duration);
    }

    public void reportProcessEndState(EndState node) {
        Count count = (Count)this.processEndStateCounts.get(node);
        if (count == null) {
            count = new Count((Model)this, this.buildName(node, SimulationConstants.NAME_PREFIX_PROCESS_END_STATE + node.getProcessDefinition().getName() + " | ", SimulationConstants.NAME_SUFFIX_PROCESS_END_STATE), true, false);
            count.reset();
            this.processEndStateCounts.put(node, count);
        }
        count.update();
    }

    public void reportProcessStart(ProcessDefinition processDefinition) {
        Count count = (Count)this.processStartCounts.get(processDefinition);
        if (count == null) {
            count = new Count((Model)this, this.buildName(processDefinition, SimulationConstants.NAME_PREFIX_PROCESS_START + processDefinition.getName() + " | ", SimulationConstants.NAME_SUFFIX_PROCESS_START), true, false);
            count.reset();
            this.processStartCounts.put(processDefinition, count);
        }
        count.update();
    }

    public String buildName(Object o, String prefix, String sufix) {
        String propertyName = this.getShortNameForObject(o);
        String name = prefix + propertyName + sufix;
        this.nameRegistry.put(name, o);
        return name;
    }

    private String getShortNameForObject(Object o) {
        if (o == null) {
            return null;
        }
        Object propertyName = o;
        if (PropertyUtils.isReadable((Object)o, (String)"name")) {
            try {
                propertyName = PropertyUtils.getProperty((Object)o, (String)"name");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (propertyName == null) {
            return null;
        }
        return propertyName.toString();
    }

    public String getShortNameFor(String fullName) {
        return this.getShortNameForObject(this.getSourceElementForName(fullName));
    }

    public Object getSourceElementForName(String fullName) {
        return this.nameRegistry.get(fullName);
    }

    public void reportFinishedProcessInstance(ProcessInstance processInstance) {
        if (this.isRememberEndedProcessInstances()) {
            this.endedProcessInstances.add(processInstance);
        }
    }

    public boolean isRememberEndedProcessInstances() {
        return this.rememberEndedProcessInstances;
    }

    public void setRememberEndedProcessInstances(boolean rememberEndedProcessInstances) {
        this.rememberEndedProcessInstances = rememberEndedProcessInstances;
    }

    public ArrayList getEndedProcessInstances() {
        return this.endedProcessInstances;
    }

    public void addBusinessFigure(BusinessFigure conf) {
        this.businessFigures.put(conf.getName(), conf);
    }

    public BusinessFigure getBusinessFigure(String name) {
        return (BusinessFigure)this.businessFigures.get(name);
    }

    public Collection getBusinessFigures() {
        return this.businessFigures.values();
    }

    public Collection getBusinessFigureTypes() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iterator = this.getBusinessFigures().iterator();
        while (iterator.hasNext()) {
            BusinessFigure figure = (BusinessFigure)iterator.next();
            if (result.contains(figure.getType())) continue;
            result.add(figure.getType());
        }
        return result;
    }

    public double getBusinessFigureSum(String businessFigureType) {
        double result = 0.0;
        Iterator iterator = this.getBusinessFigures().iterator();
        while (iterator.hasNext()) {
            BusinessFigure figure = (BusinessFigure)iterator.next();
            if (!figure.getType().equals(businessFigureType)) continue;
            result += figure.getResult();
        }
        return result;
    }
}

