/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.sim.jpdl;

import org.dom4j.Element;
import org.jbpm.JbpmConfiguration;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.sim.jpdl.SimulationHandler;
import org.jbpm.sim.jpdl.SimulationNoop;

public class SimAction
extends Action {
    private static final long serialVersionUID = 1L;
    private boolean simulate;
    private boolean simulationHandlerChecked;

    public void read(Element actionElement, JpdlXmlReader jpdlReader) {
        String simulationClass;
        super.read(actionElement, jpdlReader);
        String simulation = actionElement.attributeValue("simulation");
        if ("execute".equals(simulation) || "simulation-action".equals(actionElement.getQName().getName())) {
            this.simulate = true;
        }
        if ((simulationClass = actionElement.attributeValue("simulation-class")) != null) {
            this.simulate = true;
            this.actionDelegation.setClassName(simulationClass);
            this.actionDelegation.setConfiguration(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext executionContext) throws Exception {
        if (!this.simulationHandlerChecked) {
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            try {
                ClassLoader processClassLoader = JbpmConfiguration.getProcessClassLoader((ProcessDefinition)executionContext.getProcessDefinition());
                currentThread.setContextClassLoader(processClassLoader);
                Object delegation = this.actionDelegation.getInstance();
                if (delegation instanceof SimulationHandler) {
                    this.simulate = true;
                    this.referencedAction = new ActionHandlerDelegation((SimulationHandler)delegation);
                } else if (delegation instanceof SimulationNoop) {
                    this.simulate = false;
                }
                this.simulationHandlerChecked = true;
            }
            finally {
                currentThread.setContextClassLoader(contextClassLoader);
            }
        }
        if (this.simulate) {
            super.execute(executionContext);
        }
    }

    private class ActionHandlerDelegation
    extends Action {
        private SimulationHandler delegate;
        private static final long serialVersionUID = 1L;

        public ActionHandlerDelegation(SimulationHandler delegate) {
            this.delegate = delegate;
        }

        public void execute(ExecutionContext executionContext) throws Exception {
            this.delegate.simExecute(executionContext);
        }
    }
}

